% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate_Panel.R
\name{GeneratePanel}
\alias{GeneratePanel}
\title{Generate an artificial Micro-Panel (longitudinal) Data}
\usage{
GeneratePanel(
  n,
  Param,
  NbVisit,
  VisitFreq = NULL,
  TimeVar = NULL,
  RegModel = NULL,
  ClusterProb = NULL,
  Rho = NULL,
  units = NULL
)
}
\arguments{
\item{n}{An integer specifying the number of individuals (trajectories) being observed.}

\item{Param}{Object of \code{\link[base]{data.frame}} containing regression parameters for each cluster.
The dimensions are the various number of generating clusters and the fixed number of parameters.
The second dimension (the fixed number of parameters) is given by the type of regression model specified by the argument "RegModel".
For more information about the parameters, see documentation of: \code{\link{ParamLinear}} for linear model, \code{\link{ParamQuadrat}} for quadratic,
\code{\link{ParamCubic}} for cubic model and \code{\link{ParamExpon}} for exponential model.}

\item{NbVisit}{A positive integer numeric input defining expected number of visits. Option is \emph{Fixed} or \emph{Random}.
Number of visits given by the argument \code{VisitFreq}. If \code{VisitFreq} is \emph{Fixed}, the \code{NbVisits} defines exact number of visits for all individuals.
If \code{VisitFreq} is \emph{Random} then each individual has different number of visits.
The number of visits is then generated from the poisson distribution with the mean (lambda) equal to \code{NbVisits}.}

\item{VisitFreq}{String that defines the frequency of visits for each individual. Option is \emph{Random} or \emph{Fixed}. If set to \emph{Fixed} or not defined, each individual has the same number of visits given by \code{NbVisits}.
If set as \emph{Random} the number of visits is generated from poisson distribution for each individual with the mean equal to the argument \code{NbVisits}.
For example if this parameter is set as 5 then the random integer from interval of -5 to 5 is drawned and added to the time variable.
Make sure that \code{TimeVar} must be lower then the number of days in parameter \code{units}.}

\item{TimeVar}{A positive integer representing daily, time variability of the occurrence of repeated measurement (timepoint) from the regular,
fixed occurrence (visit) given by the argument units.
For example, if this argument is set to 5 then the random integer from interval of -5 to 5 is drawn and added to the time variable.
TimeVar must be lower than the regular frequency of repeat measurement given by the argument units.}

\item{RegModel}{String specifying the mathematical function for generating trajectory for each of n individuals. Options are \emph{linear},
\emph{quadratic}, \emph{cubic} or \emph{exponential}.
If set to \emph{linear} or not defined, then each trajectory has a linear trend.
If set to \emph{quadratic}, then each trajectory has a quadratic development in time.
If set to \emph{cubic} then each trajectory has cubic development.
If set to \emph{exponential}, then each trajectory has exponential development.}

\item{ClusterProb}{Numeric scalar (for 2 clusters) or a vector of numbers (for >2 clusters) defining the probability of each cluster.
If not defined, then each cluster has the same occurrence probability.}

\item{Rho}{A numeric scalar specifying autocorrelation parameter with the values from range 0 to 1.
If set as 0 or not define then there is no autocorrelation between the within-individual repeated observations.}

\item{units}{String defining the units of time series. Options are \emph{day}, \emph{week}, \emph{month} or \emph{year}.}
}
\value{
Generates artificial panel data.
}
\description{
This function creates artificial linear or non-linear micro-panel (longitudinal) data coming from
generating process with a certain function (linear, quadratic, cubic, exponencial) set of parameters
(fixed and random (intercept, slope) effects of time).
}
\examples{
set.seed(123)
#Simple Linear model where each individual has 10 observations.
data <- GeneratePanel(n = 100, Param = ParamLinear, NbVisit = 10)

#Exponential model where each individual has 10 observations.
data <- GeneratePanel(100, ParamExpon, NbVisit = 10, VisitFreq = "Fixed", RegModel = "exponential")
PanelPlot(data)

#Cubic model where each individual has random number of observations on daily basis.
#Average number of observation is given by parameter NbVisit.
data <- GeneratePanel(n = 100, Param = ParamCubic, NbVisit = 100, RegModel = "cubic", units = "day")
PanelPlot(data)

#Quadratic model where each individual has random number of observations.
#Each object is observede weekly with variability 2 days.
data <- GeneratePanel(5,ParamQuadrat,NbVisit=50,RegModel="quadratic",units="week",TimeVar=2)
PanelPlot(data)

#Generate panel data with linear trend with 75\% objects in first cluster and 25\% in the second.
data <- GeneratePanel(n = 100, Param = ParamLinear, NbVisit = 10, ClusterProb = c(0.75, 0.25))
PanelPlot(data, colour = "Cluster")
}
\keyword{CluMP}
