% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportMeasuredTraits.R
\name{exportMeasuredTraits}
\alias{exportMeasuredTraits}
\title{Extract and format measured traits}
\usage{
exportMeasuredTraits(x)
}
\arguments{
\item{x}{An object of class \code{CM_list} containing raw ClimMob trial data.}
}
\value{
A data frame of class \code{CM_df} with one row per genotype observation,
  including block ID, plot, genotype name, collection moment, trait name, value,
  and value type. Returns an empty \code{CM_df} if no measured traits are present.
}
\description{
Extracts non-ranking, plot-level trait data from a ClimMob trial object. The function 
detects variables ending in "_a", "_b", or "_c", infers the trait and collection moment,
and reshapes the data into long format for analysis.
}
\details{
If no measured traits are found in the data (i.e., no variables ending in "_a", "_b",
or "_c"), the function returns an empty \code{CM_df} object with valid column names.
}
\seealso{
Other export functions: 
\code{\link{exportBlockData}()},
\code{\link{exportTrialMetadata}()},
\code{\link{exportTricotRanks}()},
\code{\link{exportVariablesDescription}()}
}
\concept{export functions}
