% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{wsdi}
\alias{wsdi}
\title{Warm spell duration}
\usage{
wsdi(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{daily maximum temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
days
}
\description{
Number of days which are part of groups of at least 6 consecutive days when TX > 90th percentile. The 90th percentile is computed based on the time scale selected (month, season or year) not daily as ETCCDI does. If you want to compute daily you can use RClimDex package.
}
\examples{
data(data_all)
wsdi(data=data_all$tx)
}
