% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{tx10p}
\alias{tx10p}
\title{Percentage of cold days}
\usage{
tx10p(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{daily maximum temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
percentage
}
\description{
Percentages of days with TX lower than the 10th percentile. The 10th percentile is computed based on the time scale selected (month, season or year) not daily as ETCCDI does. If you want to compute daily you can use RClimDex package.
}
\section{Formula}{
 \deqn{cd = \frac{No. days TX < 10p} {No. days} * 100}
}

\examples{
data(data_all)
tx10p(data=data_all$tx)
}
