% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rates_time.R
\name{plot_rates_time}
\alias{plot_rates_time}
\title{Visualize a rate test time series}
\usage{
plot_rates_time(test_rates_output, model_number, ...)
}
\arguments{
\item{test_rates_output}{Rate output from \link{test_rates}.}

\item{model_number}{The number of the model you wish to visualise from the rate output.}

\item{...}{Other options to be passed to \link[geoscale]{geoscalePlot}.}
}
\value{
Nothing is returned, but a plot is produced.
}
\description{
Given the results from a rates test produces a time series visualization for a specific model.
}
\details{
The raw output from \link{test_rates} can be difficult to interpret without visualization and this function provides a means for doing that when the desired output is a time series (other functions will be added for other types of rate test).

The function will only work for a single model, but in practice the user may wish to produce multiple plots in which case they simply need to rn the function multiple times or setup a multipanel window first with \link{layout}, or similar.

Plots use the \link[geoscale]{geoscale} package to add geologic time to the x-axis and interested users should consult the documentation tere for a full ist of options (passed via ...) in the function (see example below).

Calculated rates (changes per lineage million years) are plotted as filled circles and models are plotted as horizontal lines labelled by rate parameters (lambda_i).
}
\examples{

\donttest{
# Make time-scaled first MPT for Day 2016 data set:
time_tree <- ape::read.tree(text = paste0("(Biarmosuchus_tener:0.5,",
  "(((Hipposaurus_boonstrai:3.5,(Bullacephalus_jacksoni:0.75,",
  "Pachydectes_elsi:0.75):0.75):0.75,(Lemurosaurus_pricei:7.166666667,",
  "(Lobalopex_mordax:4.333333333,((Lophorhinus_willodenensis:3.666666667,",
  "(Proburnetia_viatkensis:0.8333333333,(Lende_chiweta:2,",
  "(Paraburnetia_sneeubergensis:1,Burnetia_mirabilis:2):1):1.833333333)",
  ":0.8333333333):0.8333333333,(BP_1_7098:2.25,Niuksenitia_sukhonensis:",
  "1.25):1.25):0.8333333333):0.8333333333):3.083333333):1.95,",
  "(Ictidorhinus_martinsi:15.9,(RC_20:11.6,(Herpetoskylax_hopsoni:11.3,",
  "Lycaenodon_longiceps:0.3):0.3):0.3):0.3):0.3);"))

# Add root age to tree:
time_tree$root.time <- 269.5

# Prune continuous block from day 2016:
cladistic_matrix <- prune_cladistic_matrix(
  cladistic_matrix = day_2016,
  blocks2prune = 1
)

# Generate nine two million year time bins:
time_bins <- matrix(data = c(seq(from = 270, to = 252, length.out = 10)[1:9],
  seq(from = 270, to = 252, length.out = 10)[2:10]), ncol = 2,
  dimnames = list(LETTERS[1:9], c("fad", "lad")))

# Set class as timeBins:
class(time_bins) <- "timeBins"

# Run test rates function for each time bin partition:
test_rates_output <- test_rates(
  time_tree = time_tree,
  cladistic_matrix = cladistic_matrix,
  time_partitions = partition_time_bins(n_time_bins = 9),
  time_bins = time_bins
)

# Plot 97th time bin partition model:
plot_rates_time(
  test_rates_output = test_rates_output,
  model_number = 97, units = "Stage", cex.ts = 1, cex.age = 1,
  abbrev = "Stage"
)
}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
