% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_all_treeshape_labellings.r
\name{permute_all_treeshape_labellings}
\alias{permute_all_treeshape_labellings}
\title{Label treeshapes}
\usage{
permute_all_treeshape_labellings(treeshapes, labels)
}
\arguments{
\item{treeshapes}{A vector of treeshape(s) in the same format as \link{permute_treeshapes}.}

\item{labels}{A character vector of tip labels to use for labelling.}
}
\value{
A list of the same length as \code{treeshapes} composed of character vectors of labelled phylogenetic trees in the Newick format (Felsenstein 2004).
}
\description{
Given a treeshape and set of labels, permutes all possible labelled phylogenetic trees.
}
\details{
A treeshape is an unlabelled phylogenetic tree and as such can be labelled to produce a phylogenetic tree. This function takes a treeshape and a set of labels and generates (permutes) all possible labellings, i.e., all phylogenetic trees which a treeshape represents.

Note that the star tree always allows only a single labelling, whereas any more resolved treeshape will have multiple labellings.

Here treeshapes are encoded in the same pseudo-Newick format as the \link{permute_treeshapes} function, e.g.:

(((3),1),(1,(2)));

(Where each pair of parentheses represents an internal node, each number the number of tips, each comma separates sets of tips, and the semicolon denotes the root clade.)
}
\examples{

# Label some six-tip treeshapes with the letters A-F:
permute_all_treeshape_labellings(
  treeshapes = c(
    "(6);",
    "((3),(3));",
    "(1,(1,(1,(1,(2)))));"
  ),
  labels = LETTERS[1:6]
)

}
\references{
Felsenstein, J., 2004. \emph{Inferring Phylogenies}. Sinauer Associates, Inc., Sunderland.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
