% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_costMatrix.R
\name{check_costMatrix}
\alias{check_costMatrix}
\title{Check a costMatrix object for errors}
\usage{
check_costMatrix(costmatrix)
}
\arguments{
\item{costmatrix}{A costMatrix object.}
}
\value{
An error message or empty vector if no errors found.
}
\description{
Internal function to check a costMatrix object for errors.
}
\details{
Costmatrix objects are more complex than what will typically be shown to the user. This function checks this hidden structure and reports any errors it finds.

These checks include rules 1-7 from Hoyal Cuthill and lloyd (i prep.).
}
\examples{

# Make an unordered costmatrix:
costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "unordered"
)

# Check that this is a valid costMatrix object (should return empty vector):
check_costMatrix(costmatrix = costmatrix)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
