% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolution.R
\name{deconvolution_barplot}
\alias{deconvolution_barplot}
\title{Stacked barplot of deconvolution results}
\usage{
deconvolution_barplot(
  deconvoluted_data,
  meta_data,
  sample_id_column,
  true_label_column,
  color_dict = NULL,
  show_x_label = FALSE,
  base_size = 14,
  ...
)
}
\arguments{
\item{deconvoluted_data}{Result from running `run_deconvolution`}

\item{meta_data}{Data.frame containing metadata from deconvoluted samples}

\item{sample_id_column}{Name of the column containing the sample id in the meta_data data.frame}

\item{true_label_column}{Name of the column containing the true labels of the samples in the meta_data data.frame}

\item{color_dict}{Named string featuring colors as values and labels (true labels) as names}

\item{show_x_label}{A boolean, if `TRUE` the sample labels in the X axis will be shown. Default is `FALSE`.}

\item{base_size}{An integer defining the base size of the text in the plot. Default is `14`.}

\item{...}{Parameters passed to the ggplot2::theme function.}
}
\value{
A list with the data and the ggplot2 plot object.
}
\description{
Stacked barplot of deconvolution results
}
