% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_param.r
\name{structuralParameter}
\alias{structuralParameter}
\title{Set structural parameter in model object}
\usage{
structuralParameter(
  .Object,
  paramName,
  fixedEffName = NULL,
  randomEffName = NULL,
  style = "LogNormal",
  hasRandomEffect = NULL
)
}
\arguments{
\item{.Object}{Model object}

\item{paramName}{Name of the structural parameter}

\item{fixedEffName}{Name of the corresponding fixed effect}

\item{randomEffName}{Name of the corresponding random effect;
only applicable to population models.}

\item{style}{Use to specify the relationship of
the structural parameter with its corresponding fixed effect,
random effect, and covariate, if exists.
\itemize{
\item \code{"LogNormal" } (Default): The structural parameter
is defined as \code{Product * exp(Eta)}
\item \code{"LogNormal1"}: The structural parameter
is defined as \code{Sum * exp(Eta)}
\item \code{"LogNormal2"}: The structural parameter
is defined as \code{exp(Sum + Eta)}
\item \code{"LogitNormal"}: The structural parameter
is defined as \code{ilogit(Sum + Eta)}
\item \code{"Normal"}: The structural parameter
is defined as \code{Sum + Eta)}
}
    \code{Product} denotes the product of the corresponding
    fixed effect and covariate effect terms (if exists),
    \code{Eta} represents the corresponding random effect,
    and \code{Sum} denotes the sum of its corresponding fixed effect
    and covariate effect terms (if exists).}

\item{hasRandomEffect}{Set to \code{FALSE} to remove
the corresponding random effect from the model.
Only applicable to population models.
If \code{NULL} the system will automatically set
 \code{hasRandomEffect = TRUE} for population models,
 and \code{hasRandomEffect = FALSE} for individual models.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Use to specify the relationship of the structural parameter with corresponding fixed effect,
random effect, and covariate.
}
\examples{

model <- pkindirectmodel(
  indirectType = "LimitedInhibition",
  isBuildup = FALSE,
  data = pkpdData,
  ID = "ID",
  Time = "Time",
  A1 = "Dose",
  CObs = "CObs",
  EObs = "EObs"
)

# Change style of structural parameter "Imax" to "LogitNormal"
# and rename fixed effect to "tvlogitImax"
model <- structuralParameter(model,
  paramName = "Imax",
  style = "LogitNormal", fixedEffName = "tvlogitImax"
)

# Remove random effect for structural parameter "IC50"
model <- structuralParameter(model,
  paramName = "IC50",
  hasRandomEffect = FALSE
)

}
