% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\name{addADDL}
\alias{addADDL}
\title{Adds ADDL extra column definition to model object}
\usage{
addADDL(.Object, ADDL, II)
}
\arguments{
\item{.Object}{Model object}

\item{ADDL}{Column mapping argument specifying corresponding "ADDL" column in input data set}

\item{II}{Column mapping argument specifying corresponding "II" column in input data set}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Specify ADDL column definition in model object instead of specifying ADDL through \code{\link{addDoseCycle}}
}
\examples{
\donttest{
pkData1 <- pkData
pkData1$ii <- 0
pkData1$addl <- 0
 model <- pkmodel(numComp = 2,
                  absorption = "FirstOrder",
                  ID = "Subject",
                  Time = "Act_Time",
                  CObs = "Conc",
                  Aa = "Amount",
                  data = pkData1,
                  modelName = "PkModel",
                  workingDir = tempdir())
 model <- addADDL(model, ADDL = "addl", II = "ii")
}

}
