% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeTableDef.R
\docType{class}
\name{NlmeTableDef-class}
\alias{NlmeTableDef-class}
\alias{NlmeTableDef}
\title{Class initializer for NlmeTableDef}
\arguments{
\item{name}{Name of the generated simulation file.}

\item{timesList}{Numeric; Time values for simulation.
Applicable for time-based models only. Ignored when \code{"keepSource=TRUE"}}

\item{covrSet}{Character; Vector of covariate names. Simulation point is added
when the covariate value is set. See \code{\link{covariateNames}}}

\item{whenDose}{Character; Vector of dosing compartment names.
Simulation point is added when the dose value is set.}

\item{whenObs}{Character; String of observed variables names.
Simulation point is added when the observation value is set.}

\item{variablesList}{Character; List of variables from the model for simulation.}

\item{keepSource}{Logical; Set to \code{TRUE} to keep the number of rows appearing
in the table the same as the number of rows in the input dataset.}

\item{timeAfterDose}{Set to \code{TRUE} to output time after dose.}

\item{IRES}{Logical; Set to \code{TRUE} to output individual residuals.
Valid only if whenObs is specified.}

\item{Weight}{Logical; Set to \code{TRUE} to output the weight of current observation.
Valid only if whenObs is specified.}

\item{IWRES}{Logical; Set to \code{TRUE} to output individual weighted residuals.
Valid only if whenObs is specified.}

\item{mode}{Character; The mode of output. Options are \code{"all"} (default),
\code{"unique"}, \code{"first"}.
Only applicable to non time-based models for the case where only \code{covrSet}
is defined or the case where only \code{covrSet} and \code{variablesList} are defined.

Option \code{"all"} (default): it outputs all the rows invoked by specified covariates.
Option \code{"unique"}: if the values in a row are the same as the ones
in the previous row for the current subject, then the row is omitted; otherwise, it is printed out.
Option \code{"first"}: it outputs only the first row for each subject.}
}
\description{
Creates NlmeTableDef class object used to specify parameters
for fitting runs
}
\keyword{internal}
