% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.r
\name{estimatesUI}
\alias{estimatesUI}
\title{Shiny GUI to examine the model and evaluate estimates for fixed effects.}
\usage{
estimatesUI(model, host = NULL)
}
\arguments{
\item{model}{Model object.}

\item{host}{Optional host parameter of class \code{hostParams}.
If \code{NULL}, local host will be used.}
}
\value{
A model object of class \code{NlmePmlModel}
}
\description{
Shiny GUI to examine the model and evaluate estimates for fixed effects.
}
\examples{
if (interactive()) {
library(Certara.RsNLME)
host <- hostParams(
  parallelMethod = "None",
  hostName = "local",
  numCores = 1
)

model <- pkmodel(
  parameterization = "Clearance",
  absorption = "Intravenous",
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  A1 = "Amount",
  CObs = "Conc",
  Time = "Act_Time",
  modelName = "pk_model"
)

model <- estimatesUI(model, host)
}

}
