% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darwin_data.R
\name{darwin_data}
\alias{darwin_data}
\title{Initialize darwin data structure.}
\usage{
darwin_data(
  project_dir,
  working_dir = NULL,
  output_dir = NULL,
  key_models_dir = NULL,
  ...
)
}
\arguments{
\item{project_dir}{Directory containing input files for pyDarwin (e.g., options.json).}

\item{working_dir}{Directory containing misc results folders generated from a pyDarwin search.
This is the default location of the key_models, output, and temp folders.}

\item{output_dir}{Directory containing output files such as "results.csv" and final control files.
Default location is inside \code{working_dir/output}.}

\item{key_models_dir}{Directory of the key_models folder. Default location is inside \code{working_dir/key_models}.
Note, key models are not imported if argument is \code{NULL}, explicitly specify \code{key_models_dir} to import files for \code{\link{darwinReportUI}}.}

\item{...}{Additional args.}
}
\value{
Object of class \code{darwin_data}.
}
\description{
Initialize darwin data structure.
}
\details{
If \code{working_dir} and \code{output_dir} are sub directories of \code{project_dir}, these arguments can be ignored.
The \code{key_models_dir} is not required to initialize the \code{darwin_data} object. If specified, however, key models data will
be imported which may take time given the number of key models and size of output tables. See \code{\link{import_key_models}}.
}
