% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{boot_effect}
\alias{boot_effect}
\title{Bootstrap Confidence Intervals for Functional Effect Curves}
\usage{
boot_effect(
  logspect,
  res,
  alpha_effect,
  beta_effect,
  X,
  nbase,
  frq1,
  frq2,
  nrank,
  ind,
  level,
  nboot,
  method = "rrr_get",
  verb = FALSE
)
}
\arguments{
\item{logspect}{Matrix of estimated log-spectra.}

\item{res}{Matrix of residuals from cepstral regression.}

\item{alpha_effect}{Vector of estimated intercept effect function.}

\item{beta_effect}{Matrix of estimated covariate effect functions.}

\item{X}{Covariate matrix.}

\item{nbase}{Number of cepstral basis functions.}

\item{frq1}{Frequency grid used for cepstral modeling.}

\item{frq2}{Frequency grid used for reconstructing spectra.}

\item{nrank}{Rank for reduced-rank regression.}

\item{ind}{A vector of indices indicating which covariates to compute effect confidence intervals for.}

\item{level}{Confidence level.}

\item{nboot}{Number of bootstrap iterations.}

\item{method}{Regression method: "rrr", "ols", or "env".}

\item{verb}{Logical; if TRUE, prints bootstrap iteration number.}
}
\value{
A list with:
\describe{
\item{\code{alpha_ci}}{Matrix with lower and upper CI for intercept effect.}
\item{\code{beta_ci}}{Array or matrix of lower and upper CI for covariate effects.}
}
}
\description{
Computes bias-corrected percentile bootstrap confidence intervals for the intercept
and covariate effect functions in cepstral-based regression models.
}
\examples{
set.seed(123)
N <- 10
len <- 12
nbase <- 2
nrank <- 1
nboot <- 10
level <- 0.95
p <- 2
ind <- 1:p

Y <- matrix(rnorm(N * nbase), nrow = N, ncol = nbase)
X <- matrix(rnorm(N * p), nrow = N, ncol = p)
frq <- seq(1, nbase) / len

rrr_out <- rrr_get(X, Y, frq, nbase, nrank)

res_matrix <- rrr_out$res
if (ncol(res_matrix) != length(frq)) {
  res_matrix <- matrix(
  res_matrix[, 1:length(frq)],
  nrow = N,
  ncol = length(frq))}

eff <- effect_get(rrr_out$alph, rrr_out$bet, frq, nbase, ind)
alpha_eff <- eff$alpha_effect
beta_eff <- eff$beta_effect

logspect <- matrix(rnorm(N * length(frq)), nrow = N, ncol = length(frq))

boot_ci <- boot_effect(
  logspect = logspect,
  res = res_matrix,
  alpha_effect = alpha_eff,
  beta_effect = beta_eff,
  X = X,
  nbase = nbase,
  frq1 = frq,
  frq2 = frq,
  nrank = nrank,
  ind = ind,
  level = level,
  nboot = nboot,
  method = "rrr_get",
  verb = TRUE
)

plot(frq, beta_eff[, 1], type = "l", col = "blue", lwd = 2,
     ylab = "Effect", xlab = "Frequency",
     main = paste("Effect Function and", level*100, "\% CI for Covariate", ind[1]))
lines(frq, boot_ci[[ind[1]]][, 1], col = "red", lty = 2)
lines(frq, boot_ci[[ind[1]]][, 2], col = "red", lty = 2)
legend("topright", legend = c("Effect", "Bootstrap CI"), col = c("blue", "red"),
       lty = c(1, 2), lwd = c(2, 1))
}
