% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_prior_distribution.R
\name{set_prior_distribution}
\alias{set_prior_distribution}
\title{Add prior distribution draws}
\usage{
set_prior_distribution(model, n_draws = 4000)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{n_draws}{A scalar. Number of draws.}
}
\value{
An object of class \code{causal_model} with the `prior_distribution`
  attached to it.
}
\description{
Add `n_param x n_draws` database of possible parameter draws to the model.
}
\examples{
make_model('X -> Y') |>
  set_prior_distribution(n_draws = 5) |>
  inspect("prior_distribution")

}
\seealso{
Other set: 
\code{\link{set_confound}()},
\code{\link{set_restrictions}()}
}
\concept{set}
