% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-cp.R
\encoding{UTF-8}
\name{catr_wfs_get_parcels_bbox}
\alias{catr_wfs_get_parcels_bbox}
\alias{catr_wfs_get_parcels_zoning}
\alias{catr_wfs_get_parcels_parcel}
\alias{catr_wfs_get_parcels_neigh_parcel}
\alias{catr_wfs_get_parcels_parcel_zoning}
\title{WFS INSPIRE: Download cadastral parcels}
\usage{
catr_wfs_get_parcels_bbox(
  x,
  what = c("parcel", "zoning"),
  srs = NULL,
  verbose = FALSE
)

catr_wfs_get_parcels_zoning(cod_zona, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_parcel(rc, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_neigh_parcel(rc, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_parcel_zoning(cod_zona, srs = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See \strong{Bounding box}. It could be:
\itemize{
\item A numeric vector of length 4 with the coordinates that defines
the bounding box: \code{c(xmin, ymin, xmax, ymax)}
\item A \code{sf/sfc} object, as provided by the \CRANpkg{sf} package.
}}

\item{what}{Information to load. It can be:
\itemize{
\item \code{"parcel"} for cadastral parcels.
\item \code{"zoning"} for cadastral zoning.
}}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{wfs_service} column. See
\strong{Bounding box}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{cod_zona}{Cadastral zone code.}

\item{rc}{The cadastral reference to be extracted.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Get the spatial data of cadastral parcels and zones. The WFS Service allows
to perform several types of queries:
\itemize{
\item By bounding box: Implemented on \code{catr_wfs_get_parcels_bbox()}. Extract
objects included in the bounding box provided. See \strong{Bounding box}.
}

\itemize{
\item By zoning: Implemented on \code{catr_wfs_get_parcels_zoning()}. Extract
objects of a specific cadastral zone.
}

\itemize{
\item By cadastral parcel: Implemented on \code{catr_wfs_get_parcels_parcel()}.
Extract cadastral parcels of a specific cadastral reference.
}

\itemize{
\item Neighbor cadastral parcels: Implemented on
\code{catr_wfs_get_parcels_neigh_parcel()}. Extract neighbor cadastral parcels
of a specific cadastral reference.
}

\itemize{
\item Cadastral parcels by zoning: Implemented on
\code{catr_wfs_get_parcels_parcel_zoning()}. Extract cadastral parcels of a
specific cadastral zone.
}
}
\section{API Limits}{

The API service is limited to the following constraints:
\itemize{
\item \verb{"parcel}: Bounding box of 1km2 and a maximum of 5,000 elements.
\item \code{"zoning"}: Bounding box of 25km2 and a maximum of 5,000 elements.
}
}

\section{Bounding box}{

When \code{x} is a numeric vector, make sure that the \code{srs} matches the
coordinate values. Additionally, the function queries the bounding box on
\href{https://epsg.io/25830}{EPSG:25830} - ETRS89 / UTM zone 30N, to overcome
a potential bug on the API side.

When \code{x} is a \code{\link[sf:sf]{sf}} object, the value \code{srs} is ignored. In
this case, the bounding box of the \code{\link[sf:sf]{sf}} object would be
used for the query (see \code{\link[sf:st_bbox]{sf::st_bbox()}}).

The result is always provided in the SRS of the \code{\link[sf:sf]{sf}} object
provided as input.
}

\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
cp <- catr_wfs_get_parcels_bbox(
  c(
    233673, 4015968, 233761, 4016008
  ),
  srs = 25830
)

library(ggplot2)

ggplot(cp) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.catastro.hacienda.gob.es/webinspire/documentos/inspire-ad-WFS.pdf}{API Documentation}.

\href{https://www.catastro.hacienda.gob.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}.
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wms_get_layer}()},
\code{\link{inspire_wfs_get}()}

Other INSPIRE WFS services:
\code{\link{catr_srs_values}},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{inspire_wfs_get}()}

Other parcels: 
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()}

Other spatial: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{INSPIRE}
\concept{WFS}
\concept{parcels}
\concept{spatial}
