% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupedBar.R, R/groupedBar.default.R,
%   R/groupedBar.formula.R
\name{groupedBar}
\alias{groupedBar}
\alias{groupedBar.default}
\alias{groupedBar.formula}
\title{Grouped bar chart}
\usage{
groupedBar(resp, ...)

\method{groupedBar}{default}(
  resp,
  condvar = NULL,
  percent = TRUE,
  print = TRUE,
  cond.name = deparse(substitute(condvar)),
  resp.name = deparse(substitute(resp)),
  ...
)

\method{groupedBar}{formula}(formula, data = parent.frame(), subset, ...)
}
\arguments{
\item{resp}{a factor variable. If \code{resp} is numeric, it will be coerced to a
factor variable.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{condvar}{a factor variable to condition on. If \code{NULL}, then a bar
plot of just the \code{resp} variable will be created. If \code{condvar} is
numeric, it will be coerced to a factor variable.}

\item{percent}{a logical value. Should the y-axis give percent or counts?}

\item{print}{a logical value. If \code{TRUE}, print out the table.}

\item{cond.name}{Label for variable \code{condvar}.}

\item{resp.name}{Label for variable \code{resp}.}

\item{formula}{a formula of the form \code{x ~ condvar}. If \code{x} or
\code{condvar} is (are) not a factor variable, then it (they) will be
coerced into one. Formula can also be \code{ ~ x} for a single factor variable.}

\item{data}{a data frame that contains the variables in the formula.}

\item{subset}{an optional vector specifying a subset of observations to be
used.}
}
\value{
Returns invisibly a table of the variable(s).
}
\description{
Create a bar chart of a single categorical variable or a grouped bar chart
of two categorical variables.
}
\details{
For a single factor variable, a bar plot. If two factor variables are given,
then a bar plot of \code{x} conditioned by \code{condvar}.  This command
uses R's \code{table} command so missing values are automatically removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{groupedBar(default)}: Grouped bar chart

\item \code{groupedBar(formula)}: Grouped bar chart

}}
\examples{


groupedBar(states03$Region)

\dontrun{
groupedBar(states03$DeathPenalty, states03$Region, legend.loc = "topleft")

#Using a formula syntax:

groupedBar(~Region, data = states03)
groupedBar(DeathPenalty ~ Region, data = states03, legend.loc = "topleft")
}

}
\author{
Laura Chihara
}
\keyword{bar}
\keyword{grouped}
\keyword{plot}
