% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi2cub1cov.R
\name{chi2cub1cov}
\alias{chi2cub1cov}
\title{Pearson \eqn{X^2} statistic  for CUB models with one discrete covariate for feeling}
\usage{
chi2cub1cov(m, ordinal, covar, pai, gama)
}
\arguments{
\item{m}{Integer: number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{covar}{Vector of the selected covariate for explaining the feeling component}

\item{pai}{Uncertainty parameter}

\item{gama}{Vector of parameters for the feeling component, with length equal to 2
to account for an intercept term (first entry)}
}
\value{
It returns the following results in a list:
\item{df}{Number of degrees of freedom}
\item{chi2}{Value of the Pearson fitting measure}
\item{dev}{Deviance indicator}
}
\description{
Compute the \eqn{X^2} statistic of Pearson for the goodness of fit of a CUB model for ordinal responses, where the feeling parameter
is explained via a logistic transform of the only discrete covariate. It groups ratings in
classes according to the values of the covariate.
}
\references{
Tutz, G. (2011). \emph{Regression for categorical data}, Cambridge Series in Statistical
and Probabilistic Mathematics
}
\keyword{internal}
