% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_penCSC.R
\name{tune_penCSC}
\alias{tune_penCSC}
\title{tune_penCSC}
\usage{
tune_penCSC(
  time,
  status,
  vars.list,
  data,
  horizons,
  event,
  rhs = ~1,
  tri.list = NULL,
  method = "cv",
  k = 10,
  times = 25,
  p = 0.7,
  strat.var = NULL,
  metrics = "Brier",
  final.metric = NULL,
  alpha.grid = NULL,
  lambda.grid = NULL,
  nlambdas.list = NULL,
  grow.by = NULL,
  standardize = TRUE,
  keep = NULL,
  preProc.fun = function(x) x,
  preProc.fun.test = NULL,
  parallel = FALSE,
  preProc.pkgs = NULL,
  preProc.globals = NULL,
  core.nums = max(1L, ceiling(parallelly::availableCores()/2))
)
}
\arguments{
\item{time}{A character showing the name of the time variable in the data.}

\item{status}{A character showing the name of the status/event variable in the data.}

\item{vars.list}{A named list containing the variables to be included in each cause-specific model. Variables can be vectors of variable names or a one sided formula. Names of the list must be the events and exactly the same as values in the status variable. See `Examples` for details.}

\item{data}{A data frame containing the information of the variables.}

\item{horizons}{A vector of time horizons which we want the absolute risk predictions to be evaluated at.}

\item{event}{The value for event of interest which we want the absolute risk predictions to be evaluated for. This must be one of the values in the status variable of the data.}

\item{rhs}{A right hand sided formula indicating the variables to be used in estimating the inverse probability of censoring weighting (IPCW) model. Default is \code{~1}.}

\item{tri.list}{A list specifying training data indices for arbitrary resampling. Default is \code{NULL} but when specified, \code{method} and all arguments related to it will be ignored.}

\item{method}{Resampling method to be used for hyper-parameter tuning. Values can be: \code{'cv'} for cross validation, \code{'repcv'} for repeated cross validation, \code{'lgocv'} for monte-carlo cross validation, \code{'loocv'} for leave one out cross validation and \code{'boot'} for bootstrap. Default is \code{'cv'}.}

\item{k}{Number of folds. Only applicable for \code{method='cv'} and \code{method='repcv'}. Default is 10.}

\item{times}{Repeat number of the resampling process. Only applicable for \code{method='repcv'}, \code{method='lgocv'} and \code{method='boot'}. Default is 25.}

\item{p}{The fraction of data to be used as the training set during resampling. Only applicable for \code{method='lgocv'}. Default is 0.7.}

\item{strat.var}{A single character indicating name of the strata variable to be used to create resamples. If numerical, groups will be specified based on percentiles. Default is \code{NULL} which considers status variable as a factor and creates the resamples based on different levels of it.}

\item{metrics}{Evaluation metric (loss function) to be used. Values can be \code{'Brier'} for IPCW brier score, \code{'AUC'} for IPCW AUC or a vector of both. Default is \code{'Brier'}.}

\item{final.metric}{The evaluation metric to decide the best hyper-parameters set for the final fits on the whole data. When \code{NULL} which is the default value, it takes the value from \code{metrics}. If both \code{'Brier'} and \code{'AUC'} were specified in metrics and \code{final.metric} is \code{NULL}, \code{'Brier'} will be used.}

\item{alpha.grid}{A named list containing a sequence of alpha values to be evaluated for each cause-specific model. Names of the list must be the events and exactly the same as values in the status variable. Default is \code{NULL} which orders the function to set \code{seq(0,1,.5)} for all cause-specific models. See `Details` for more information.}

\item{lambda.grid}{A named list containing a sequence of lambda values to be evaluated for each cause-specific model. Names of the list must be the events and exactly the same as values in the status variable. Default is \code{NULL} which orders the function to calculate exclusive lambda sequences for all causes. See `Details` for more information.}

\item{nlambdas.list}{A names list of single integers indicating the length of lambda sequences which are calculated automatically by the function for each cause. Only applicable when \code{lambda.grid=NULL}. Default is NULL which sets all lengths to 5. See `Details` for more information.}

\item{grow.by}{Difference between the values in the growing sequence of lambda values to find the maximum value that makes the null model. Only applicable when \code{lambda.grid=NULL}. Default is 0.01. See `Details` for more information.}

\item{standardize}{Logical indicating whether the variables must be standardized or not during model fitting procedures. Default is \code{TRUE}.}

\item{keep}{A character vector of the names of variables that should not be shrunk in all model fitting procedures. Default is \code{NULL}.}

\item{preProc.fun}{A function that accepts a data and returns a modified version of it that has gone through the user's desired pre-processing steps. All modifications from this function will be done during the resampling procedures to avoid data leakage. It will modify all training and test set(s) during the validation unless other argument \code{preProc.fun.test} is specified by user and then it only affects the training set(s). Default is \code{function(x) x}. Also see the description of \code{preProc.fun.test} argument.}

\item{preProc.fun.test}{A function the exact same characteristics and description as \code{preProc.fun} argument. If user specifies a separate function for \code{preProc.fun.test}, it will only affect test set(s) during validation while the function from \code{preProc.fun} will affect the training set(s). Default is \code{NULL} which means function from \code{preProc.fun} will be used on both training and test set(s) during validation. Also see the description of \code{preProc.fun} argument.}

\item{parallel}{Logical indicating whether the tuning process should be performed in parallel or not. Default is \code{FALSE}.}

\item{preProc.pkgs}{A character vector containing the names of packages that was used in creating user's \code{preProc.fun} while using parallel computation. Only applicable if \code{parallel=T} and \code{preProc.fun} is a user specified function using functions from other packages. See 'Examples' for details.}

\item{preProc.globals}{A character vector containing names of objects included in \code{preProc.fun} to be considered as global objects while using parallel computation. The most frequent ones are the names of the user specified pre processing function or functions within this function. Only applicable if \code{parallel=T} and \code{preProc.fun} is a user specified function. See 'Examples' for details.}

\item{core.nums}{Number of CPU cores to be used for parallel computation. Only applicable if \code{parallel=T}. Default is \code{parallelly::availableCores()/2}.}
}
\value{
A list containing the detailed information of the hyper-parameter tuning and the validation process, best combination of hyper-parameters and the final fits based on the whole data using the best obtained hyper-parameters. Use \code{$} to explore all the involved information.
}
\description{
A flexible function for tuning the involved hyper-parameters of a penalized cause-specific-cox model with elastic net penalty using the linking idea.
}
\details{
\code{tune_penCSC} has the ability to automatically determine the candidate sequences of alpha & lambda values. Setting any of \code{alpha.grid} & \code{lambda.grid} to \code{NULL} will order the function to calculate them automatically.
The process of determining the lambda values automatically is by:
\enumerate{
\item Starting from lambda=0, the algorithm fits LASSO models until finding a lambda value that creates a NULL model where all variables were shrunk to be exactly zero.
\item The obtained lambda value will be used as the maximum value of a sequence starting from 0. The length of this sequence is controlled by values in \code{nlambdas.list}.
}
This will be done for each cause-specific model to create exclusive sequences of lambdas for each of them.
}
\examples{
\dontrun{

library(riskRegression)

set.seed(123)

d <- sampleData(n = 500,outcome = 'competing.risks')

vl <- list('1'=~X1+X3+X7+X9+X10,

          '2'=c('X1','X2','X6','X10'))

set.seed(123)

tri.l <- caret::createFolds(as.factor(d$event),k=3,list=TRUE,returnTrain=TRUE)

test <- tune_penCSC(time='time',status='event',vars.list=vl,data=d,horizons=median(d$time),

                   event=1,tri.list=tri.l,metrics='AUC',alpha.grid=list('1'=0,'2'=c(.5,1)),

                   nlambdas.list=list('1'=3,'2'=3))

test

}

}
\references{
Friedman J, Hastie T, Tibshirani R (2010). "Regularization Paths for Generalized Linear Models via Coordinate Descent." Journal of Statistical Software, 33(1), 1-22. \doi{10.18637/jss.v033.i01}, \url{https://www.jstatsoft.org/v33/i01/}.

Saadati, M, Beyersmann, J, Kopp-Schneider, A, Benner, A. Prediction accuracy and variable selection for penalized cause-specific hazards models. Biometrical Journal. 2018; 60: 288– 306. \doi{10.1002/bimj.201600242}.

Gerds TA, Kattan MW (2021). Medical Risk Prediction Models: With Ties to Machine Learning (1st ed.). Chapman and Hall/CRC. \doi{10.1201/9781138384484}

Pfeiffer, R. M., & Gail, M. M. (2017). Absolute risk: Methods and applications in clinical management and public health.

Kuhn, M. (2008). Building Predictive Models in R Using the caret Package. Journal of Statistical Software, 28(5), 1–26. \doi{10.18637/jss.v028.i05}.

Bengtsson H (2021). “A Unifying Framework for Parallel and Distributed Processing in R using Futures.” The R Journal, 13(2), 208–227. \doi{10.32614/RJ-2021-048}.

Vaughan D, Dancho M (2022). furrr: Apply Mapping Functions in Parallel using Futures. \url{https://github.com/futureverse/furrr}, \url{https://furrr.futureverse.org/}.

Therneau T (2022). A Package for Survival Analysis in R. R package version 3.3-1, \url{https://CRAN.R-project.org/package=survival}.

Wickham H, Averick M, Bryan J, Chang W, McGowan L, François R, et al. Welcome to the tidyverse. J Open Source Softw. 2019 Nov 21;4(43):1686.

Bache S, Wickham H (2022). magrittr: A Forward-Pipe Operator for R. \url{https://magrittr.tidyverse.org}, \url{https://github.com/tidyverse/magrittr}.
}
\author{
Shahin Roshani
}
