% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_zscore}
\alias{n_zscore}
\title{Z-score a vector}
\usage{
n_zscore(x, m_sd = c(0, 1))
}
\arguments{
\item{x}{A numeric vector}

\item{m_sd}{A vector \code{c(m, sd)}, where \code{m} is desired mean and \code{sd} is the target standard deviation.}
}
\value{
Numeric vector
}
\description{
Standardises a vector \code{x} by scaling it to have a mean and standard deviation specified by \code{m_sd}.
}
\details{
This function also supports parameter specification in \code{iMeta} for the \code{\link[=Normalise.coin]{Normalise.coin()}} method.
To do this, add columns \code{zscore_mean}, and \code{zscore_sd} to the \code{iMeta} table, which specify the
mean and standard deviation to scale each indicator to, respectively. Then set \code{f_n_para = "use_iMeta"} within the
\code{global_specs} list. See also examples in the \href{https://bluefoxr.github.io/COINr/articles/normalise.html}{normalisation vignette}.
}
\examples{
x <- runif(20)
n_zscore(x)

}
