#' postProb
#'
#' This function calculates the probabilities that each of the new data point
#' falls into the distributions defined by the parameters. Used when 
#' calculating the sample by component matrix.
#' @param params A vector of the distribution parameters
#' @param newData The new data to calculate the probabilities for 
#' @return Returns the probability that the newData is in the distributions
postProb = function(params,newData)
{
  pois = FALSE
  numComps = ncol(params)
  
  #Checks whether the distributions are poisson or normal
  if (is.null(numComps)){
    numComps=length(params)
    pois = TRUE
  }

  #Create empty vector for probabilities  
  probs = c()

  #Loop through each of the components
  for (i in 1:numComps){
    if (params[i]==0){
      temp = as.numeric(newData == 0)
    }
    if (pois){
      temp = stats::dpois(newData,params[i])
    } else {
      temp = stats::dnorm(newData,params[1,i],params[2,i])
    }
    probs = cbind(probs,temp)
  }
 
  #Calculates a normalized density value as the probability 
  probs = apply(probs,1,function(x){x/sum(x)})
  return(t(probs))
}
