% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_basin_daily_precip.R
\name{cv_basin_daily_precip}
\alias{cv_basin_daily_precip}
\title{Calculates basin-averaged daily precipitation}
\usage{
cv_basin_daily_precip(
  netcdf_directory = ".",
  scenario = "pr_day_ACCESS-CM2_ssp126_r2i1p1f1_gn_20150101-21001231_cannc_SPQM_",
  basin_zone_area = NULL,
  temp_file = TRUE
)
}
\arguments{
\item{netcdf_directory}{Required. Directory containing NetCDF files.}

\item{scenario}{Required. Full name of scenario to be used. This is the file name omitting the zone number.}

\item{basin_zone_area}{Required. A list object returned by \code{cv_clip_basin()} which contains the zone numbers to be used,
the basin area within each zone, and rasters of each zone containing the area of each
element.}

\item{temp_file}{If \code{TRUE} (the default) then temporary files will be used when extracting the values
from the NetCDF files. This option is slower than keeping all the values in
memory (which is what occurs if \code{temp_file = TRUE}), \emph{but} allows the function
to work with very large basins, which may require more memory than is available.}
}
\value{
Reruns a data frame with 2 columns: \code{date} and \code{precipitation}. The
\code{date} is a standard \R date over the interval 2015-01-01 to 2100-12-31, and the
\code{precipitation} is the basin mean value.
}
\description{
Extracts the daily precipitation values from CMIP6 NetCDF files, and calculates
the mean precipitation for a given basin for each time interval. The original files are in
longitude-latitude projection, so the areas of the cells varies. The cell areas
are used to weight the precipitation when computing the basin mean precipitation.

The CMIP6 data are arranged by zone in 9 files. As a given basin may lie over more than
one zone, it may necessary to read in data from more than one NetCDF file when computing
the basin mean precipitation.
}
\examples{
\donttest{
# This function is marked to not be tested as it requires local copies of the CMIP6 data files
# which are many GB in size
library(terra)
az_raster <- cv_zone_area_raster()
fpath <- system.file("extdata", "07BF001.shp", package = "CMIP6VisR")
basin_vector <- vect(fpath)
basin_areas <- cv_clip_basin(az_raster, basin_vector)
netcdf_directory <- "."
values <- cv_basin_daily_precip(netcdf_directory = netcdf_directory,
                               basin_zone_area = basin_areas,
                               temp_file = FALSE)
}
}
\seealso{
\code{\link{cv_clip_basin}}
}
\author{
Kevin Shook
}
