% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmgfm.R
\name{MSVR}
\alias{MSVR}
\title{Select the number of factors}
\usage{
MSVR(
  XList,
  Z,
  types,
  numvarmat,
  Alist = NULL,
  q_max = 20,
  threshold = 1e-05,
  ...
)
}
\arguments{
\item{XList}{a list consisting of multiple matrices in which each matrix has the same type of values, i.e., continuous, or count, or binomial/binary values.}

\item{Z}{a matrix, the fixed-dimensional covariate matrix with control variables.}

\item{types}{a string vector, specify the variable type in each matrix in \code{XList};}

\item{numvarmat}{a \code{length(types)}-by-d matrix, specify the number of variables in modalities that belong to the same type.}

\item{Alist}{an optional vector, the offset for each unit; default as full-zero vector.}

\item{q_max}{an optional string, specify the maximum number of factors; default as 20.}

\item{threshold}{an optional positive value, a cutoff to filter the singular values that are smaller than it.}

\item{...}{other arguments passed to CMGFM}
}
\value{
return the estimated number of factors.
}
\description{
Select the number of factors using maximum singular value ratio based method
}
\details{
None
}
\examples{
pveclist <- list('gaussian'=c(50, 150),'poisson'=c(50, 150),
   'binomial'=c(100,60))
q <- 6
sigmavec <- rep(1,3)
pvec <- unlist(pveclist)
datlist <- gendata_cmgfm(pveclist = pveclist, seed = 1, n = 300,d = 3,
                         q = q, rho = rep(1,length(pveclist)), rho_z=0.2,
                         sigmavec=sigmavec, sigma_eps=1)
XList <- datlist$XList
Z <- datlist$Z
numvarmat <- datlist$numvarmat
types <- datlist$types
hq <- MSVR(XList, Z, types=types, numvarmat, q_max=20)

print(c(q_true=q, q_est=hq))
}
\references{
None
}
\seealso{
None
}
