% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_clv_model.R
\docType{class}
\name{clv.model-class}
\alias{clv.model-class}
\title{CLV Model providing model related functionalities}
\description{
Objects of class \code{clv.fitted} contain an instance of class clv.model that is called
whenever a model-related step is performed (Strategy pattern).

This class is the abstract parent class from which new clv models inherit. It implements
only stubs (with stop()) for all methods that need to be implemented in order
to obtain a functional \code{clv.fitted} object.
}
\section{Slots}{

\describe{
\item{\code{name.model}}{Name of the model as it should be displayed}

\item{\code{fn.model.generic}}{Method (generic) to apply on (sub-class of) clv.data in order to fit the model.}

\item{\code{names.original.params.model}}{character vector that defines the names of the model parameters as they should be reported}

\item{\code{names.prefixed.params.model}}{character vector that defines the names of the model parameters as they are named during LL optimization}

\item{\code{start.params.model}}{numeric vector of default values at original scale that should be used for the LL optimization if the user does not provide start parameters. Named with \code{names.original.params.model}.}

\item{\code{optimx.defaults}}{list of default arguments for calling \code{\link[optimx]{optimx}} with \code{do.call}. Named after the respective arguments in optimx.}
}}

\seealso{
CLV model subclasses with and without support for fitting with correlation \linkS4class{clv.model.with.correlation}, \linkS4class{clv.model.no.correlation}

Class using its instances: \linkS4class{clv.fitted}
}
\keyword{internal}
