% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.interval.R
\name{confidence.interval}
\alias{confidence.interval}
\title{Compute Wald-Based Confidence Intervals for Logit and Predicted Probability}
\usage{
confidence.interval(model, data, confidence.level = 0.95)
}
\arguments{
\item{model}{A fitted logistic regression model from \code{glm()} with \code{family = binomial}.}

\item{data}{A data frame containing the new observations for which predictions and confidence intervals are needed.}

\item{confidence.level}{Confidence level for the interval estimates. Defaults to 0.95.}
}
\value{
A list with two elements:
\describe{
\item{\code{logit}}{A data frame with predicted logit values and their lower and upper confidence limits.}
\item{\code{estimated.prob}}{A data frame with predicted probabilities and their lower and upper confidence limits.}
}
}
\description{
Calculates Wald-based confidence intervals for the predicted logit values and estimated
probabilities for new data points, based on a fitted logistic regression model.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 2

# Fit logistic regression model with selected predictors, Table 2.3
mod2.3 <- glm(
  fracture ~ age + priorfrac + raterisk,
  family = binomial,
  data = glow500
)

# Create a new data point for prediction
new.x <- data.frame(
  age = 65,
  priorfrac = "Yes",
  raterisk = "Same"
)

# Compute the 95\% confidence interval for the predicted probability
confidence.interval(mod2.3, data = new.x, confidence.level = 0.95)

}
