% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FATE.R
\name{FATE}
\alias{FATE}
\title{Estimation of ATE under high-dimensional error-prone data}
\usage{
FATE(Data, cov_e, Consider_D, pi_10, pi_01)
}
\arguments{
\item{Data}{A n x (p+2) matrix of the data, where n is sample size and the first
p columns are covariates with the order being
Xc (the covariates associated with both treatment and outcome),
Xp (the covariates associated with outcome only),
Xi (the covariates associated with treatment only),
Xs (the covariates independent of outcome and treatment),
the last second column is treatment, and the last column is outcome.}

\item{cov_e}{Covariance matrix in the measurement error model.}

\item{Consider_D}{Feature screening with treatment effects accommodated.
\code{Conidser_D = TRUE} refers to feature screening with A and (1-A) incorporated.
\code{Consider_D = FALSE} will not multiply with A and (1-A).}

\item{pi_10}{Misclassifcation probability is
P(Observed Treatment = 1 | Actual Treatment = 0).}

\item{pi_01}{Misclassifcation probability is
P(Observed Treatment = 0 | Actual Treatment = 1).}
}
\value{
\item{ATE}{A value of the average treatment effect.}

\item{wAMD}{A weighted absolute mean difference.}

\item{Coef_prop_score}{A table containing coefficients of propensity score.}

\item{Kersye_table}{The selected covariates by feature screening.}

\item{Corr_trt_table}{A summarized table containing corrected treatment.}
}
\description{
This function aims to estimate ATE by selecting informative
covariates and correcting for measurement error in covariates and
misclassification in treatments. The function FATE reflects the strategy of
estimation method: Feature screening, Adaptive lasso, Treatment  adjustment,
and Error correction for covariates.
}
\examples{
##### Example 1: Input the data without measurement correction #####

## Generate a multivariate normal X matrix
mean_x = 0; sig_x = 1; rho = 0; n = 50; p = 120
Sigma_x = matrix( rho*sig_x^2 ,nrow=p ,ncol=p )
diag(Sigma_x) = sig_x^2
Mean_x = rep( mean_x, p )
X = as.matrix( mvrnorm(n ,mu = Mean_x,Sigma = Sigma_x,empirical = FALSE) )

## Data generation setting
## alpha: Xc's scale is 0.2 0.2 and Xi's scale is 0.3 0.3
## so this refers that there is 2 Xc and Xi
## beta: Xc's scale is 2 2 and Xp's scale is 2 2
## so this refers that there is 2 Xc and Xp
## rest with following setup
Data_fun <- Data_Gen(X, alpha = c(0.2,0.2,0,0,0.3,0.3), beta = c(2,2,2,2,0,0)
, theta = 2, a = 2, sigma_e = 0.75, e_distr = 10, num_pi = 1, delta = 0.8,
linearY = TRUE, typeY = "cont")

## Extract Ori_Data, Error_Data, Pi matrix, and cov_e matrix
Ori_Data=Data_fun$Data
Pi=Data_fun$Pi
cov_e=Data_fun$cov_e
Data=Data_fun$Error_Data
pi_01 = pi_10 = Pi[,1]

## Input data into model without error correction
Model_fix = FATE(Data, matrix(0,p,p), Consider_D = FALSE, 0, 0)

##### Example 2: Input the data with measurement correction #####

## Input data into model with error correction
Model_fix = FATE(Data, cov_e, Consider_D = FALSE, Pi[,1],Pi[,2])

}
