% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_download_AWS_INMET.R
\name{download_AWS_INMET_daily}
\alias{download_AWS_INMET_daily}
\title{Download of hourly data from automatic weather stations (AWS) of INMET-Brazil in daily aggregates}
\usage{
download_AWS_INMET_daily(stations, start_date, end_date)
}
\arguments{
\item{stations}{The stations code (ID - WMO code) for download. To see the station ID, please see the function *see_stations_info*.}

\item{start_date}{Date that start the investigation, should be in the following format (1958-01-01 /Year-Month-Day)}

\item{end_date}{Date that end the investigation, should be in the following format (2017-12-31 /Year-Month-Day)}
}
\value{
Returns a data.frame with the AWS data requested
}
\description{
This function will download the hourly AWS data of INMET and it will aggregate the data in a daily time scale, based on the period of time selected (start_date and end_date).
}
\examples{
\dontrun{
df <- download_AWS_INMET_daily(
  stations = c("A001", "A042"),
  start_date = "2016-01-01",
  end_date = "2018-12-31"
)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
