% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{PathwaysModule}
\alias{PathwaysModule}
\title{Delineate differential pathway modules with high biological interpretability}
\usage{
PathwaysModule(
  pathways_matrix = NULL,
  control_label = NULL,
  power = NULL,
  minModuleSize = NULL,
  mergeCutHeight = NULL,
  cutoff = 70,
  MinNumPathways = 5,
  p.adjust.method = "fdr",
  exact = TRUE,
  ancestor_anno = NULL
)
}
\arguments{
\item{pathways_matrix}{A pathway matrix generated by the BioM2( target='pathways') function.}

\item{control_label}{The label of the control group ( A single number, factor, or character )}

\item{power}{soft-thresholding power for network construction. Detail for WGCNA::blockwiseModules()}

\item{minModuleSize}{minimum module size for module detection. Detail for WGCNA::blockwiseModules()}

\item{mergeCutHeight}{dendrogram cut height for module merging. Detail for WGCNA::blockwiseModules()}

\item{cutoff}{Thresholds for Biological Interpretability Difference Modules}

\item{MinNumPathways}{Minimum number of pathways included in the biologically interpretable difference module}

\item{p.adjust.method}{p-value adjustment method.(holm", "hochberg", "hommel", "bonferroni", "BH", "BY",}

\item{exact}{Whether to divide GO pathways more accurately (work when ancestor_anno=NULL)}

\item{ancestor_anno}{Annotations for ancestral relationships (like data('GO_Ancestor') )}
}
\value{
A list containing differential module results that are highly biologically interpretable
}
\description{
Delineate differential pathway modules with high biological interpretability
}
