% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_multiscale_overlap}
\alias{simulate_multiscale_overlap}
\title{Simulate Multiple Center Patterns with Fixed Centers}
\usage{
simulate_multiscale_overlap(
  grid_size = 60,
  n_centers = 3,
  Ra_seq = c(10, 5, 1),
  Rb_seq = c(10, 5, 1),
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{grid_size}{Size of the spatial grid (default: 60)}

\item{n_centers}{Number of pattern centers to generate. If 1, center is placed at grid center.
If > 1, centers are randomly placed but fixed by seed (default: 3)}

\item{Ra_seq}{Vector of inner circle radii (default: c(10, 5, 1))}

\item{Rb_seq}{Vector of outer ring radii (default: c(10, 5, 1))}

\item{seed}{Random seed for reproducible center placement (default: 123)}

\item{verbose}{Logical; if TRUE, show progress bar and messages (default: TRUE)}
}
\value{
List of data frames, each containing X, Y coordinates and signal_1, signal_2 binary signals
}
\description{
Generate spatial patterns with multiple circular centers at fixed positions.
Similar to simulate_multiscale but with centers placed at fixed locations for reproducible
pattern generation. Creates concentric circle patterns with inner circle A and outer ring B
at various radius combinations.
}
\examples{
\donttest{
# Generate multi-center patterns with fixed centers
patterns <- simulate_multiscale_overlap()

# Single center at grid center
patterns_single <- simulate_multiscale_overlap(n_centers = 1)

# Custom parameters with multiple centers
Ra_seq <- seq(from = 10, to = 3, length.out = 4)
Rb_seq <- seq(from = 15, to = 2, length.out = 4)
patterns <- simulate_multiscale_overlap(
  Ra_seq = Ra_seq, 
  Rb_seq = Rb_seq, 
  n_centers = 2,
  seed = 456
)
}
}
