% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omega_Indices.R
\name{Omega_H}
\alias{Omega_H}
\title{OmegaH}
\usage{
Omega_H(Lambda, Theta)
}
\arguments{
\item{Lambda}{is a matrix of factor loadings}

\item{Theta}{is a vector of indicator error variances}
}
\value{
A \code{numeric}, the omega reliability estimate for all factors.
}
\description{
Computes hierarchical omega reliability estimate for all factors as described in
Rodriguez, Reise, and Haviland (2016).
}
\details{
\code{Omega_H} is called by \code{\link{bifactorIndices}} and the various convenience functions
for exploratory models and/or Mplus output,
which are the only functions in this package intended for casual users.
}
\section{References}{

Rodriguez, A., Reise, S. P., & Haviland, M. G. (2016). Evaluating bifactor models:
Calculating and interpreting statistical indices. Psychological Methods, 21(2),
137 \doi{10.1037/met0000045}.
}

\examples{
Lambda <- matrix(c(.82, .10,   0,   0,
                   .77, .35,   0,   0,
                   .79, .32,   0,   0,
                   .66, .39,   0,   0,
                   .51,   0, .71,   0,
                   .56,   0, .43,   0,
                   .68,   0, .13,   0,
                   .60,   0, .50,   0,
                   .83,   0,   0, .47,
                   .60,   0,   0, .27,
                   .78,   0,   0, .28,
                   .55,   0,   0, .75),
                   ncol = 4, byrow = TRUE)
colnames(Lambda) <- c("General", "SF1", "SF2", "SF3")
Theta <- rep(1, nrow(Lambda)) - rowSums(Lambda^2)
Omega_H(Lambda, Theta)

}
\seealso{
\code{\link{Omega_S}}, \code{\link{bifactorIndices}}
}
