% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perc_beamplot.R
\name{perc_beamplot}
\alias{perc_beamplot}
\title{Create a beamplot using percentile values}
\usage{
perc_beamplot(rd, au_name = "Example Researcher", ...)
}
\arguments{
\item{rd}{is a dataframe with two columns: (i) publication year and (ii) percentile value with one row per paper/dataset.}

\item{au_name}{is the name of the researcher this beamplot belongs to.}

\item{...}{further parameters passed to stripchart.}
}
\description{
Create a beamplot using percentile values.
}
\details{
perc_beamplot(rd, au_name='Name of researcher')
Only the rd is argument mandatory. It has to be a dataframe with two columns: (i) publication year and (ii) percentile value with one row per paper/dataset.

Literature:

- Haunschild, R., Bornmann, L., & Adams, J. (2019). R package for producing beamplots as a preferred alternative to the h index when assessing single researchers (based on downloads from Web of Science), Scientometrics, DOI 10.1007/s11192-019-03147-3, preprint: https://arxiv.org/abs/1905.09095
- Bornmann, L. & Marx, W. (2014a). Distributions instead of single numbers: percentiles and beam plots for the assessment of single researchers. Journal of the American Society of Information Science and Technology, 65(1), 206–208
- Bornmann, L. & Marx, W. (2014b). How to evaluate individual researchers working in the natural and life sciences meaningfully? A proposal of methods based on percentiles of citations. Scientometrics, 98(1), 487-509. DOI: 10.1007/s11192-013-1161-y.
- Bornmann, L., & Haunschild, R. (2018). Plots for visualizing paper impact and journal impact of single researchers in a single graph. Scientometrics, 115(1), 385-394. DOI: 10.1007/s11192-018-2658-1.
}
\examples{

\dontrun{perc_beamplot(rd, au_name='Name of researcher')}

}
