% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_fuels_cwd.R
\name{CoarseFuels}
\alias{CoarseFuels}
\title{CoarseFuels}
\usage{
CoarseFuels(
  tree_data,
  fuel_data,
  sp_codes = "4letter",
  units = "metric",
  summed = "no"
)
}
\arguments{
\item{tree_data}{A dataframe or tibble with the following columns: time, site, plot, exp_factor, species, and dbh. Each row must be an observation of an individual tree.}

\item{fuel_data}{A dataframe or tibble. If the summed parameter is set to "no" the following columns are required: time, site, plot, transect, length_1000h, diameter, and status. If the summed parameter is set to "yes" the following columns are required: time, site, plot, transect, length_1000h, ssd_R, and ssd_S.}

\item{sp_codes}{Specifies whether the species column in tree_data follows the four-letter code or FIA naming convention. Must be set to either "4letter" or "fia." The default is set to "4letter".}

\item{units}{Specifies whether the input data are in metric (centimeters, meters, and trees per hectare) or imperial (inches, feet, and trees per acre) units. Inputs must be all metric or all imperial (do not mix-and-match units). The output units will match the input units (i.e., if inputs are in metric then outputs will be in metric). Must be set to either “metric” or “imperial”. The default is set to “metric”.}

\item{summed}{Specifies whether the sum-of-squared-diameters for sound and rotten 1000-hour fuels has already been calculated by the user. Must be set to either "yes" or "no". The default is set to "no".}
}
\value{
A dataframe with the following columns:
\itemize{
\item time: as described above
\item site: as described above
\item plot: as described above
\item load_1000s_Mg_ha (or load_1000s_ton_ac): fuel load of sound 1000-hour fuels in megagrams per hectare (or US tons per acre)
\item load_1000r_Mg_ha (or load_1000r_ton_ac): fuel load of rotten 1000-hour fuels in megagrams per hectare (or US tons per acre)
\item load_cwd_Mg_ha (or load_cwd_ton_ac): total coarse woody debris fuel load (1000-hour sound + 1000-hour rotten) in megagrams per hectare (or US tons per acre)
\item sc_length_1000s: slope-corrected transect length (i.e., horizontal transect length) for sound 1000-hour fuels in either meters or feet. This is the total horizontal length of transect sampled for sound 1000-hour fuels at the specific time:site:plot.
\item sc_length_1000r: slope-corrected transect length (i.e., horizontal transect length) for rotten 1000-hour fuels in either meters or feet. This is the total horizontal length of transect sampled for rotten 1000-hour fuels at the specific time:site:plot.
}
}
\description{
Estimates coarse woody (1000-hour) fuel loads from line-intercept transects. See \href{https://github.com/kearutherford/BerkeleyForestsAnalytics/tree/main}{README} for details.
}
\examples{
CoarseFuels(tree_data = overstory_demo,
            fuel_data = cwd_YS_demo,
            sp_codes = "4letter",
            units = "metric",
            summed = "yes")

CoarseFuels(tree_data = overstory_demo,
            fuel_data = cwd_NS_demo)

}
