/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.GammaDistribution;

public class ChiSquareDistribution
extends GammaDistribution {
    protected double n;

    public ChiSquareDistribution(double d) {
        super(d / 2.0, 2.0);
        this.n = d;
    }

    @Override
    public double pdf(double d) {
        return ChiSquareDistribution.pdf(d, this.n);
    }

    @Override
    public double cdf(double d) {
        return ChiSquareDistribution.cdf(d, this.n);
    }

    @Override
    public double quantile(double d) {
        return ChiSquareDistribution.quantile(d, this.n);
    }

    @Override
    public double mean() {
        return ChiSquareDistribution.mean(this.n);
    }

    @Override
    public double variance() {
        return ChiSquareDistribution.variance(this.n);
    }

    public static double pdf(double d, double d2) {
        return ChiSquareDistribution.pdf(d, d2 / 2.0, 2.0);
    }

    public static double cdf(double d, double d2) {
        return ChiSquareDistribution.cdf(d, d2 / 2.0, 2.0);
    }

    public static double quantile(double d, double d2) {
        return ChiSquareDistribution.quantile(d, d2 / 2.0, 2.0);
    }

    public static double mean(double d) {
        return d;
    }

    public static double variance(double d) {
        return 2.0 * d;
    }
}

