/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.util.HashMap;

public class ConditionalTraitSimulationHelper
implements Reportable {
    private final TreeDataLikelihood treeLikelihood;
    private final TreeTrait treeTrait;
    private final ContinuousTraitPartialsProvider topDataModel;
    private final HashMap<ContinuousTraitPartialsProvider, ParentMapHelper> parentMap;

    public ConditionalTraitSimulationHelper(TreeDataLikelihood treeDataLikelihood) {
        this.treeLikelihood = treeDataLikelihood;
        ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.topDataModel = continuousDataLikelihoodDelegate.getDataModel();
        this.parentMap = new HashMap();
        this.makeParentMap(this.topDataModel, this.parentMap);
        this.treeTrait = treeDataLikelihood.getTreeTrait(this.topDataModel.getTipTraitName());
    }

    public TreeTrait getTreeTrait() {
        return this.treeTrait;
    }

    private void makeParentMap(ContinuousTraitPartialsProvider continuousTraitPartialsProvider, HashMap<ContinuousTraitPartialsProvider, ParentMapHelper> hashMap) {
        int n = 0;
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider2 : continuousTraitPartialsProvider.getChildModels()) {
            hashMap.put(continuousTraitPartialsProvider2, new ParentMapHelper(continuousTraitPartialsProvider, n, continuousTraitPartialsProvider2.getTraitDimension()));
            this.makeParentMap(continuousTraitPartialsProvider2, hashMap);
            n += continuousTraitPartialsProvider2.getTraitDimension();
        }
    }

    public double[] drawTraitsAbove(ContinuousTraitPartialsProvider continuousTraitPartialsProvider) {
        int n = continuousTraitPartialsProvider.getTraitDimension();
        if (continuousTraitPartialsProvider == this.topDataModel) {
            this.treeLikelihood.fireModelChanged();
            return (double[])this.treeTrait.getTrait(this.treeLikelihood.getTree(), null);
        }
        ParentMapHelper parentMapHelper = this.parentMap.get(continuousTraitPartialsProvider);
        double[] dArray = this.drawTraitsBelow(parentMapHelper.parent);
        if (parentMapHelper.traitOffset == 0 && parentMapHelper.traitDimension == parentMapHelper.parent.getDataDimension()) {
            return dArray;
        }
        int n2 = this.treeLikelihood.getTree().getExternalNodeCount();
        double[] dArray2 = new double[n2 * n];
        int n3 = parentMapHelper.traitOffset;
        int n4 = 0;
        int n5 = parentMapHelper.parent.getTraitDimension();
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray, n3, dArray2, n4, parentMapHelper.traitDimension);
            n3 += n5;
            n4 += n;
        }
        return dArray2;
    }

    public double[] drawTraitsBelow(ContinuousTraitPartialsProvider continuousTraitPartialsProvider) {
        double[] dArray = this.drawTraitsAbove(continuousTraitPartialsProvider);
        return continuousTraitPartialsProvider.drawTraitsBelowConditionalOnDataAndTraitsAbove(dArray);
    }

    public JointSamples drawTraitsAboveAndBelow(ContinuousTraitPartialsProvider continuousTraitPartialsProvider) {
        return this.drawTraitsAboveAndBelow(continuousTraitPartialsProvider, false);
    }

    public JointSamples drawTraitsAboveAndBelow(ContinuousTraitPartialsProvider continuousTraitPartialsProvider, boolean bl) {
        double[] dArray = this.drawTraitsAbove(continuousTraitPartialsProvider);
        double[] dArray2 = continuousTraitPartialsProvider.drawTraitsBelowConditionalOnDataAndTraitsAbove(dArray);
        if (bl) {
            dArray = continuousTraitPartialsProvider.transformTreeTraits(dArray);
        }
        return new JointSamples(dArray, dArray2);
    }

    @Override
    public String getReport() {
        int n;
        int n2 = 10000;
        double[] dArray = this.drawTraitsAbove(this.topDataModel);
        for (n = 1; n < n2; ++n) {
            double[] dArray2 = this.drawTraitsAbove(this.topDataModel);
            for (int i = 0; i < dArray2.length; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + dArray2[i];
            }
        }
        n = 0;
        while (n < dArray.length) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)n2;
        }
        StringBuilder stringBuilder = new StringBuilder("Trait simulation report:\n\ttree trait mean: ");
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private class ParentMapHelper {
        public final int traitOffset;
        public final int traitDimension;
        public final ContinuousTraitPartialsProvider parent;

        private ParentMapHelper(ContinuousTraitPartialsProvider continuousTraitPartialsProvider, int n, int n2) {
            this.traitOffset = n;
            this.traitDimension = n2;
            this.parent = continuousTraitPartialsProvider;
        }
    }

    public class JointSamples {
        private final double[] traitsAbove;
        private final double[] traitsBelow;

        public JointSamples(double[] dArray, double[] dArray2) {
            this.traitsAbove = dArray;
            this.traitsBelow = dArray2;
        }

        public double[] getTraitsAbove() {
            return this.traitsAbove;
        }

        public double[] getTraitsBelow() {
            return this.traitsBelow;
        }
    }
}

