/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodelxml.operators.NodeHeightOperatorParser;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;

public class ScaleNodeHeightOperator
extends AbstractAdaptableTreeOperator {
    private double tunableParameter;
    private final TreeModel tree;
    private final NodeHeightOperatorParser.OperatorType operatorType;

    public ScaleNodeHeightOperator(TreeModel treeModel, double d, double d2, NodeHeightOperatorParser.OperatorType operatorType, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        if (operatorType != NodeHeightOperatorParser.OperatorType.SCALEALL && operatorType != NodeHeightOperatorParser.OperatorType.SCALEROOT) {
            throw new UnsupportedOperationException("ScaleNodeHeightOperator can only perform SCALEALL or SCALEROOT operator types");
        }
        this.tree = treeModel;
        this.setWeight(d);
        this.tunableParameter = d2;
        this.operatorType = operatorType;
    }

    @Override
    public double doOperation() {
        double d;
        NodeRef nodeRef = this.tree.getRoot();
        if (this.operatorType == NodeHeightOperatorParser.OperatorType.SCALEALL) {
            d = this.doScaleAll();
        } else {
            double d2 = Math.max(this.tree.getNodeHeight(this.tree.getChild(nodeRef, 0)), this.tree.getNodeHeight(this.tree.getChild(nodeRef, 1)));
            double d3 = this.tree.getNodeHeight(nodeRef);
            d = this.doScaleRoot(nodeRef, d3, d2);
        }
        return d;
    }

    private double doScaleAll() {
        double d = this.tunableParameter;
        double d2 = d + MathUtils.nextDouble() * (1.0 / d - d);
        for (NodeRef nodeRef : this.tree.getNodes()) {
            if (this.tree.isExternal(nodeRef)) continue;
            double d3 = this.tree.getNodeHeight(nodeRef);
            this.tree.setNodeHeightQuietly(nodeRef, d3 * d2);
        }
        assert (this.tree.isTreeValid());
        this.tree.pushTreeChangedEvent(TreeChangedEvent.create(false, true));
        return (double)(this.tree.getInternalNodeCount() - 2) * Math.log(d2);
    }

    private double doScaleRoot(NodeRef nodeRef, double d, double d2) {
        double d3 = this.tunableParameter;
        double d4 = d3 + MathUtils.nextDouble() * (1.0 / d3 - d3);
        double d5 = d - d2;
        this.tree.setNodeHeight(nodeRef, d5 * d4 + d2);
        return -Math.log(d4);
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.tunableParameter = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.tunableParameter - 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.tunableParameter;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public String getOperatorName() {
        switch (this.operatorType) {
            case SCALEROOT: {
                return "scale(" + this.tree.getId() + " root height)";
            }
            case SCALEALL: {
                return "scaleAll(" + this.tree.getId() + " internal nodes)";
            }
        }
        throw new IllegalArgumentException("Unsupported OperatorType");
    }
}

