/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGPartitionLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.math.Poisson;
import dr.math.distributions.PoissonDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import jebl.math.Binomial;

public class PoissonPartitionLikelihood
extends ARGPartitionLikelihood {
    public static final String POISSON_PARTITION_LIKELIHOOD = "poissonPartitionLikelihood";
    PoissonDistribution pd;
    double mean;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return PoissonPartitionLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newDoubleRule("mean", false), new ElementRule(ARGModel.class, false)};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = "";
            if (xMLObject.hasId()) {
                string = xMLObject.getId();
            }
            double d = xMLObject.getDoubleAttribute("mean");
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            if (aRGModel.isRecombinationPartitionType()) {
                throw new XMLParseException("argTreeModel must be of type reassortment");
            }
            return new PoissonPartitionLikelihood(string, aRGModel, d);
        }

        @Override
        public String getParserName() {
            return PoissonPartitionLikelihood.POISSON_PARTITION_LIKELIHOOD;
        }
    };

    public PoissonPartitionLikelihood(String string, ARGModel aRGModel, double d) {
        super(string, aRGModel);
        this.pd = new PoissonDistribution(d);
        this.mean = d;
    }

    @Override
    public double getLogLikelihood(double[] dArray) {
        if ((this.getNumberOfPartitionsMinusOne() + 1) % 2 == 0) {
            return this.getEvenLogLikelihood(dArray);
        }
        return this.getOddLogLikelihood(dArray);
    }

    private double getEvenLogLikelihood(double[] dArray) {
        int n = 0;
        int n2 = 0;
        for (double d : dArray) {
            assert (d == 0.0 || d == 1.0);
            if (d == 0.0) {
                ++n;
                continue;
            }
            ++n2;
        }
        double d = Math.min(n, n2);
        double d2 = this.pd.logPdf(d);
        if (d < (double)(dArray.length / 2)) {
            return d2 - Math.log(Binomial.choose(dArray.length, d));
        }
        return d2 - Math.log(Binomial.choose(dArray.length - 1, d));
    }

    private double getOddLogLikelihood(double[] dArray) {
        int n = 0;
        int n2 = 0;
        for (double d : dArray) {
            assert (d == 0.0 || d == 1.0);
            if (d == 0.0) {
                ++n;
                continue;
            }
            ++n2;
        }
        double d = Math.min(n, n2);
        return this.pd.logPdf(d) - Math.log(Binomial.choose(dArray.length, d));
    }

    @Override
    public double[] generatePartition() {
        int n;
        int n2 = (this.getNumberOfPartitionsMinusOne() + 1) / 2;
        int n3 = 0;
        while (n3 < 1 || n3 > n2) {
            n3 = Poisson.nextPoisson(this.mean);
        }
        int[] nArray = new int[this.getNumberOfPartitionsMinusOne() + 1];
        for (n = 0; n < n3; ++n) {
            nArray[n] = 1;
        }
        MathUtils.permute(nArray);
        if (nArray[0] == 1) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = nArray[n] == 1 ? 0 : 1;
            }
        }
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void storeState() {
    }
}

