% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiagnostic.R
\name{plotDiagnostic}
\alias{plotDiagnostic}
\title{Diagnostic Plot}
\usage{
plotDiagnostic(
  out,
  start = 50,
  numSamples = 100,
  window = 0.2,
  plotWAIC = F,
  plotPSRF = T,
  plotDIC = T,
  plotTrace = T,
  graphicParameters = NULL,
  ...
)
}
\arguments{
\item{out}{object of class "bayesianOutput"}

\item{start}{start value for calculating DIC, WAIC, mPSRF and PSRF, default = 50}

\item{numSamples}{for calculating WAIC, default = 10 because of high computational costs}

\item{window}{plot range to show, vector of percents or only one value as start value for the window}

\item{plotWAIC}{whether to calculate WAIC or not, default = T}

\item{plotPSRF}{calculate and plot mPSRF/PSRF or not, default = T}

\item{plotDIC}{calculate and plot DICor not, default = T}

\item{plotTrace}{show trace plots or not, default = T}

\item{graphicParameters}{graphic parameters as list for plot function}

\item{...}{parameters to give to getSample}
}
\description{
This function plots the DIC, WAIC, mPSRF, PSRF(with upper C.I.) and traces of the parameters in dependence of iterations. DIC, WAIC are plotted separately for the chains and the trace plots also for the internal chains.
}
\examples{
\dontrun{
  
  # Create bayesian setup with  
  bayesianSetup <- createBayesianSetup(likelihood = testDensityNormal, 
                                       prior = createUniformPrior(lower = -10,
                                                                  upper = 10))
  # running MCMC
  out = runMCMC(bayesianSetup = bayesianSetup)
  
  # diagnostic plots
  plotDiagnostic(out)
}
}
\author{
Maximilian Pichler
}
