% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.power.R
\name{fisher.power}
\alias{fisher.power}
\title{Power Calculation by Fisher's Exact Test}
\usage{
fisher.power(pt, nt, pc, nc, alpha = 0.1, nsim = 10000, seed = NULL)
}
\arguments{
\item{pt}{A scalar. Probablity of success in experimental arm}

\item{nt}{A scalar. Number of subject in experimental arm}

\item{pc}{A scalar. Probablity of success in control arm}

\item{nc}{A scalar. Number of subject in control arm}

\item{alpha}{A scalar. One sided type I error rate.}

\item{nsim}{A scalar. Number of replications to calculate power. Default
100,000.}

\item{seed}{An integer. A seed for the random number generator to ensure
reproducibility. Note: For best practice, it is recommended to call
\code{set.seed()} outside of the function.}
}
\value{
A numeric scalar representing the calculated statistical power.
}
\description{
This function calculates the power by simulations using Fisher's exact test.
}
\examples{
# nsim is reduced for a quick example run
fisher.power(pt = 0.5, nt = 40, pc = 0.3, nc = 40, nsim = 1000, seed = 2000)

}
