% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian.Hybrid.Analysis.R
\name{Bayesian.Hybrid.Analysis}
\alias{Bayesian.Hybrid.Analysis}
\title{Statistical Analysis for a Bayesian Hybrid Design}
\usage{
Bayesian.Hybrid.Analysis(
  Yt = 20,
  nt = 40,
  Yc = 12,
  nc = 40,
  Ych = 73,
  nche = 40,
  nch = 234,
  sig = 0.9,
  credlev = 0.8,
  a0c = 0.001,
  b0c = 0.001,
  a0t = 0.001,
  b0t = 0.001,
  delta_threshold = 0.1
)
}
\arguments{
\item{Yt}{Number of responses in the experimental arm in the current study.}

\item{nt}{Number of patients in the experimental arm in the current study.}

\item{Yc}{Number of responses in the control arm in the current study.}

\item{nc}{Number of patients in the control arm in the current study.}

\item{Ych}{Number of responses in the control treatment in the historical study.}

\item{nche}{Equivalent number of patients borrowed from the historical study.}

\item{nch}{Total number of patients in the historical control.}

\item{sig}{Significance boundary. The hypothesis is considered significant if
the posterior probability \eqn{P(p_t > p_c | data) > sig}.}

\item{credlev}{Credible interval level (e.g., 0.95 for 95 percent CI).}

\item{a0c}{Prior alpha parameter for control response rate, \eqn{Beta(a_{0c}, b_{0c})}.}

\item{b0c}{Prior beta parameter for control response rate, \eqn{Beta(a_{0c}, b_{0c})}.}

\item{a0t}{Prior alpha parameter for experimental response rate, \eqn{Beta(a_{0t}, b_{0t})}.}

\item{b0t}{Prior beta parameter for experimental response rate, \eqn{Beta(a_{0t}, b_{0t})}.}

\item{delta_threshold}{Borrowing threshold. Borrowing occurs when
\eqn{|p_{c,trial} - p_{c,hist}| \le} \code{delta_threshold}.}
}
\value{
A list containing the following components:
\itemize{
\item \code{prob.pt.gt.pc}: Probability of experimental arm having a better posterior response rate than control.
\item \code{median_hca}: Posterior median response rate for hybrid control.
\item \code{CI_hca}: Credible interval for median response rate for hybrid control.
\item \code{median_c}: Posterior median response rate for current study control.
\item \code{CI_c}: Credible interval for median response rate for current study control.
\item \code{median_t}: Posterior median response rate for current study experimental arm.
\item \code{CI_t}: Credible interval for median response rate for current experimental arm.
\item \code{delta.m}: Posterior median response rate difference (experimental - control) based on hybrid design.
\item \code{delta.CI}: Credible interval for response rate difference based on hybrid design.
\item \code{delta.m_trial}: Posterior median response rate difference (experimental - control) based on current study only.
\item \code{delta.CI_trial}: Credible interval for response rate difference based on current study only.
\item \code{conclusion}: Statistical inference conclusion string.
}
}
\description{
This function performs the statistical analysis for a Bayesian Hybrid Design
using a dynamic power prior approach.
}
\examples{
\donttest{
# Note: This example relies on the internal package function 'borrow.wt'
Bayesian.Hybrid.Analysis(Yt=18, nt=40, Yc=13, nc=40, Ych=73,
                         nche=40, nch=234)
}
}
