% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssd.R
\name{ssd}
\alias{ssd}
\title{Sample size determination for replication success}
\usage{
ssd(
  sregionfun,
  dprior,
  power,
  nsites = 1,
  searchInt = c(.Machine$double.eps^0.5, 4),
  ...
)
}
\arguments{
\item{sregionfun}{Function that returns the success region for replication
effect estimate as a function of the replication standard error}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}

\item{nsites}{Number of sites. Defaults to \code{1}. The sites are assumed to
have the same sample size}

\item{searchInt}{Search interval for standard errors}

\item{...}{Other arguments passed to \code{uniroot}}
}
\value{
Returns an object of class \code{"ssdRS"} which is a list containing:
\tabular{ll}{
   \code{designPrior} \tab The specified \code{"designPrior"} object \cr
   \tab \cr
   \code{power} \tab The specified power \cr
   \tab \cr
   \code{powerRecomputed} \tab The recomputed power \cr
   \tab \cr
   \code{sr} \tab The required replication standard error \cr
   \tab \cr
   \code{c} \tab The required relative sample size \code{c = nr/no}
   (assuming \code{so = unitSD/no} and \code{sr = unitSD/nr}) \cr
}
}
\description{
This function computes the standard error of the replication
    effect estimate required to achieve replication success with a certain
    probability and based on a certain type of success region.
}
\examples{
## specify design prior
to1 <- 2
so1 <- 1
dprior <- designPrior(to = to1, so = so1)

## compute required standard error for significance at one-sided 2.5\%
sregionfunSig <- function(sr, alpha = 0.025) {
    successRegion(intervals = cbind(stats::qnorm(p = 1- alpha)*sr, Inf))
}
ssd(sregionfun = sregionfunSig, dprior = dprior, power = 0.8)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
