% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdPs.R
\name{porsPs}
\alias{porsPs}
\title{Probability of replication success based on the sceptical p-value}
\usage{
porsPs(level, dprior, sr)
}
\arguments{
\item{level}{Threshold for the (one-sided) sceptical p-value below which
replication success is achieved}

\item{dprior}{Design prior object}

\item{sr}{Replication standard error}
}
\value{
The probability to achieve replication success
}
\description{
This function computes the probability to achieve replication
    success based on the sceptical p-value.
}
\details{
The sceptical p-value is assumed to be uncalibrated as in Held
    (2020). The package ReplicationSuccess allows for sample size and power
    calculations with the recalibrated sceptical p-value
    (\url{https://CRAN.R-project.org/package=ReplicationSuccess}).
}
\examples{
## specify design prior
to1 <- 0.2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1)
porsPs(level = 0.025, dprior = dprior, sr = c(0.05, 0.01))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Held, L. (2020). A new standard for the analysis and design of replication
studies (with discussion). Journal of the Royal Statistical Society: Series A
(Statistics in Society), 183(2), 431-448. \doi{10.1111/rssa.12493}
}
\author{
Samuel Pawel
}
