// Generated by rstantools.  Do not edit by hand.

/*
    BayesPET.test is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BayesPET.test is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BayesPET.test.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_Censor_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 32> locations_array__ =
  {" (found before start of program)",
  " (in 'Censor', line 15, column 2 to column 20)",
  " (in 'Censor', line 16, column 2 to column 23)",
  " (in 'Censor', line 17, column 2 to column 17)",
  " (in 'Censor', line 20, column 1 to column 18)",
  " (in 'Censor', line 21, column 1 to column 21)",
  " (in 'Censor', line 22, column 1 to column 24)",
  " (in 'Censor', line 24, column 4 to column 64)",
  " (in 'Censor', line 27, column 4 to column 54)",
  " (in 'Censor', line 31, column 6 to column 54)",
  " (in 'Censor', line 30, column 11 to line 32, column 5)",
  " (in 'Censor', line 29, column 6 to column 53)",
  " (in 'Censor', line 28, column 23 to line 30, column 5)",
  " (in 'Censor', line 28, column 4 to line 32, column 5)",
  " (in 'Censor', line 23, column 18 to line 33, column 3)",
  " (in 'Censor', line 23, column 4 to line 33, column 3)",
  " (in 'Censor', line 2, column 2 to column 8)",
  " (in 'Censor', line 3, column 2 to column 8)",
  " (in 'Censor', line 4, column 18 to column 19)",
  " (in 'Censor', line 4, column 2 to column 21)",
  " (in 'Censor', line 5, column 31 to column 32)",
  " (in 'Censor', line 5, column 2 to column 34)",
  " (in 'Censor', line 6, column 2 to column 18)",
  " (in 'Censor', line 7, column 2 to column 18)",
  " (in 'Censor', line 8, column 2 to column 18)",
  " (in 'Censor', line 9, column 2 to column 18)",
  " (in 'Censor', line 10, column 2 to column 10)",
  " (in 'Censor', line 11, column 2 to column 20)",
  " (in 'Censor', line 12, column 9 to column 10)",
  " (in 'Censor', line 12, column 11 to column 12)",
  " (in 'Censor', line 12, column 2 to column 18)",
  " (in 'Censor', line 17, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_Censor final : public model_base_crtp<model_Censor> {
private:
  int N;
  int p;
  std::vector<double> t;
  std::vector<int> status;
  double a;
  double b;
  double c;
  double d;
  double m1;
  double se1;
  Eigen::Matrix<double,-1,-1> cov_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> cov{nullptr, 0, 0};
public:
  ~model_Censor() {}
  model_Censor(stan::io::var_context& context__, unsigned int
               random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_Censor_namespace::model_Censor";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 16;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 16;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 17;
      context__.validate_dims("data initialization", "p", "int",
        std::vector<size_t>{});
      p = std::numeric_limits<int>::min();
      current_statement__ = 17;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 18;
      stan::math::validate_non_negative_index("t", "N", N);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "t", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      t = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 19;
      t = context__.vals_r("t");
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "t", t, 0);
      current_statement__ = 20;
      stan::math::validate_non_negative_index("status", "N", N);
      current_statement__ = 21;
      context__.validate_dims("data initialization", "status", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      status = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 21;
      status = context__.vals_i("status");
      current_statement__ = 21;
      stan::math::check_greater_or_equal(function__, "status", status, 0);
      current_statement__ = 21;
      stan::math::check_less_or_equal(function__, "status", status, 1);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "a", "double",
        std::vector<size_t>{});
      a = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 22;
      a = context__.vals_r("a")[(1 - 1)];
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "a", a, 0);
      current_statement__ = 23;
      context__.validate_dims("data initialization", "b", "double",
        std::vector<size_t>{});
      b = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 23;
      b = context__.vals_r("b")[(1 - 1)];
      current_statement__ = 23;
      stan::math::check_greater_or_equal(function__, "b", b, 0);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "c", "double",
        std::vector<size_t>{});
      c = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 24;
      c = context__.vals_r("c")[(1 - 1)];
      current_statement__ = 24;
      stan::math::check_greater_or_equal(function__, "c", c, 0);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "d", "double",
        std::vector<size_t>{});
      d = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 25;
      d = context__.vals_r("d")[(1 - 1)];
      current_statement__ = 25;
      stan::math::check_greater_or_equal(function__, "d", d, 0);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "m1", "double",
        std::vector<size_t>{});
      m1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 26;
      m1 = context__.vals_r("m1")[(1 - 1)];
      current_statement__ = 27;
      context__.validate_dims("data initialization", "se1", "double",
        std::vector<size_t>{});
      se1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 27;
      se1 = context__.vals_r("se1")[(1 - 1)];
      current_statement__ = 27;
      stan::math::check_greater_or_equal(function__, "se1", se1, 0);
      current_statement__ = 28;
      stan::math::validate_non_negative_index("cov", "N", N);
      current_statement__ = 29;
      stan::math::validate_non_negative_index("cov", "p", p);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "cov", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(p)});
      cov_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, p,
                     std::numeric_limits<double>::quiet_NaN());
      new (&cov) Eigen::Map<Eigen::Matrix<double,-1,-1>>(cov_data__.data(),
        N, p);
      {
        std::vector<local_scalar_t__> cov_flat__;
        current_statement__ = 30;
        cov_flat__ = context__.vals_r("cov");
        current_statement__ = 30;
        pos__ = 1;
        current_statement__ = 30;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 30;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 30;
            stan::model::assign(cov, cov_flat__[(pos__ - 1)],
              "assigning variable cov", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 30;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 31;
      stan::math::validate_non_negative_index("beta", "p", p);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + p;
  }
  inline std::string model_name() const final {
    return "model_Censor";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_Censor_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ rho = DUMMY_VAR__;
      current_statement__ = 1;
      rho = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 3;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      {
        current_statement__ = 4;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(rho, c, d));
        current_statement__ = 5;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(lambda, a, b));
        current_statement__ = 6;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(beta, m1, se1));
        current_statement__ = 15;
        for (int i = 1; i <= N; ++i) {
          local_scalar_t__ hazard_scale = DUMMY_VAR__;
          current_statement__ = 7;
          hazard_scale = (lambda *
            stan::math::exp(
              stan::math::dot_product(beta,
                stan::model::rvalue(cov, "cov", stan::model::index_uni(i)))));
          local_scalar_t__ time_scale = DUMMY_VAR__;
          current_statement__ = 8;
          time_scale = stan::math::pow(hazard_scale, (-1.0 / rho));
          current_statement__ = 13;
          if (stan::math::logical_eq(
                stan::model::rvalue(status, "status",
                  stan::model::index_uni(i)), 0)) {
            current_statement__ = 11;
            lp_accum__.add(stan::math::weibull_lpdf<false>(
                             stan::model::rvalue(t, "t",
                               stan::model::index_uni(i)), rho, time_scale));
          } else {
            current_statement__ = 9;
            lp_accum__.add(stan::math::weibull_lccdf(
                             stan::model::rvalue(t, "t",
                               stan::model::index_uni(i)), rho, time_scale));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_Censor_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double rho = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      rho = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      double lambda = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      lambda = in__.template read_constrain_lb<local_scalar_t__,
                 jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(p,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(p);
      out__.write(rho);
      out__.write(lambda);
      out__.write(beta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ rho = DUMMY_VAR__;
      current_statement__ = 1;
      rho = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, rho);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, lambda);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(p),
        "assigning variable beta");
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "rho", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "lambda", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(p)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ rho = DUMMY_VAR__;
      current_statement__ = 1;
      rho = context__.vals_r("rho")[(1 - 1)];
      out__.write_free_lb(0, rho);
      local_scalar_t__ lambda = DUMMY_VAR__;
      current_statement__ = 2;
      lambda = context__.vals_r("lambda")[(1 - 1)];
      out__.write_free_lb(0, lambda);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(p, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 3;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"rho", "lambda", "beta"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(p)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "rho");
    param_names__.emplace_back(std::string() + "lambda");
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "rho");
    param_names__.emplace_back(std::string() + "lambda");
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"rho\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(p) + "},\"block\":\"parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + p);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + p);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_Censor_namespace::model_Censor;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Censor_namespace::profiles__;
}
#endif
#endif
