% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{plot.BayesPET_predtime}
\alias{plot.BayesPET_predtime}
\title{Plot method for BayesPET prediction objects}
\usage{
\method{plot}{BayesPET_predtime}(
  x,
  breaks = "Sturges",
  xlab = "Predicted calendar time to reach target number of events",
  ...
)
}
\arguments{
\item{x}{An object of class \code{"BayesPET_predtime"} returned by
\code{\link{predict_eventtime}}.}

\item{breaks}{Passed to \code{\link[graphics]{hist}}. Default is \code{"Sturges"}.}

\item{xlab}{X-axis label. Default is \code{"Calendar time to reach E_target"}.}

\item{\dots}{Additional arguments passed to methods. Not used.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Plots an object of class \code{"BayesPET_predtime"} by displaying a histogram
of posterior predictive draws of the calendar time at which the target number
of events is reached. Only finite draws are included. A vertical line indicates
the posterior median when it is finite.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
## Reduced number of chains and iterations compared to defaults
## to keep the example computationally manageable.
pred <- predict_eventtime(
  N = 200,
  E_target = 150,
  data.enroll = data_example$example_enroll,
  data.eventcensor = data_example$example_eventcensor,
  blinded = TRUE,
  p_trt = 0.5,
  chains = 2,
  iter = 2000,
  assess_window = 2,
  seed.fit = 1,
  seed.pred = 2,
  return_fit = TRUE,
  return_draws = TRUE,
  quiet = TRUE
)

print(pred)
summary(pred)
plot(pred)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET prediction: \code{\link{predict_eventtime}}, \code{\link{print.BayesPET_predtime}}, \cr
\code{\link{summary.BayesPET_predtime}}
}
