% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesPET.R
\name{fit_enroll}
\alias{fit_enroll}
\title{Fit enrollment model}
\usage{
fit_enroll(
  status_enroll,
  t_enroll,
  hyperparams_enroll = list(),
  chains = 4,
  iter = 4000,
  seed = 1,
  refresh = 0,
  warmup = floor(iter/2),
  mc.cores = 1,
  control = list(adapt_delta = 0.95),
  return_fit = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{status_enroll}{Integer vector with values \code{0} or \code{1} indicating whether
the interarrival time is observed (\code{1}) or administratively censored (\code{0}).}

\item{t_enroll}{Numeric vector giving observed or censored interarrival times.
Must be non-negative and finite.}

\item{hyperparams_enroll}{A named list of prior hyperparameters for the enrollment model.
If it is empty (\code{list()}), default values
are assigned internally.
\itemize{
\item \code{alpha_mu}: Shape parameter of the Gamma prior for the
enrollment rate \eqn{\mu} (default: \eqn{0.1}).
\item \code{beta_mu}: Rate parameter of the Gamma prior for the
enrollment rate \eqn{\mu} (default: \eqn{0.1}).
}
No other hyperparameters are allowed.}

\item{chains}{Number of Markov chain Monte Carlo (MCMC) chains. Defaults to \code{4}.}

\item{iter}{Number of iterations per chain (including warmup). Defaults to \code{4000}.}

\item{seed}{Optional integer seed passed to \code{\link[rstan]{sampling}} for reproducibility. If \code{NULL},
'Stan' generates a seed internally and results may differ across runs.
Defaults to \code{1}.}

\item{refresh}{Frequency of progress updates from \code{\link[rstan]{sampling}}. Set to \code{0} (default) to suppress output.}

\item{warmup}{Number of warmup (burn-in) iterations per chain. Must be strictly smaller
than \code{iter}. Defaults to \code{floor(iter / 2)}.}

\item{mc.cores}{Integer. Number of CPU cores to use when executing Markov
chains in parallel via \code{\link[rstan]{sampling}}. Defaults to \code{1}.
We recommend setting \code{mc.cores} to the maximum number of processors
supported by the available hardware and memory, up to the number of
chains.}

\item{control}{A named list of sampler control parameters passed to
\code{\link[rstan]{sampling}}. Examples include \code{adapt_delta} and
\code{max_treedepth}.
Defaults to \code{list(adapt_delta = 0.95)}.}

\item{return_fit}{Logical; if \code{TRUE}, also return the underlying 'rstan' \code{stanfit}
object. Defaults to \code{FALSE}.}

\item{quiet}{Logical. If \code{TRUE} (default), suppress messages and diagnostic warnings
from \code{\link[rstan]{sampling}} during model fitting. Useful for large simulation studies.}
}
\value{
A list with components:
\itemize{
\item \code{mu}: posterior draws of \eqn{\mu},
\item \code{fit}: The 'rstan' \code{stanfit} fit object (only if \code{return_fit = TRUE}).
}
}
\description{
Fits an exponential model to enrollment interarrival times and returns
posterior draws of the enrollment rate \eqn{\mu}.
}
\details{
Let \eqn{t_i} denote the interarrival time between consecutive enrollments.
The enrollment process is modeled using an exponential distribution with
rate parameter \eqn{\mu}, so that
\deqn{t_i \sim \mathrm{Exponential}(\mu),}
where \eqn{\mu > 0} represents the average enrollment rate. The corresponding
density is
\deqn{f(t) = \mu e^{-\mu t}, \quad t \ge 0.}

Administrative censoring of enrollment is handled through the indicator
\code{status_enroll}, which follows the convention:
\itemize{
\item \code{1}: the interarrival time is fully observed at \code{t_enroll}
(density contribution);
\item \code{0}: the interarrival time is administratively censored at
\code{t_enroll} (survival contribution).
}
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
example_enroll<-data_example$example_enroll

out <- fit_enroll(
  status_enroll = example_enroll$enrollstatus,
  t_enroll = example_enroll$interarrivaltime,
  seed = 1, return_fit = TRUE,
  quiet = FALSE
)

summary(out$mu)
print(out$fit)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET model fitting: \code{\link{fit_censor}}, \code{\link{fit_event_blind}},
\code{\link{fit_event_unblind}},
\code{\link{fit_models}}, \cr \code{\link{print.BayesPET_fit}}
}
