% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{DetectCpObj}
\alias{DetectCpObj}
\title{DetectCpObj class constructor}
\usage{
DetectCpObj(
  data = NULL,
  n_iterations = NULL,
  n_burnin = NULL,
  orders = NULL,
  time = NULL,
  entropy_MCMC = NULL,
  lkl_MCMC = NULL,
  phi_MCMC = NULL,
  sigma_MCMC = NULL,
  delta_MCMC = NULL,
  I0_MCMC = NULL,
  kernel_ts = NULL,
  kernel_epi = NULL,
  univariate_ts = NULL
)
}
\arguments{
\item{data}{A vector or matrix containing the observed time series.}

\item{n_iterations}{Total number of MCMC iterations.}

\item{n_burnin}{Number of burn-in iterations to discard.}

\item{orders}{A matrix where each row corresponds to the latent block
assignment (order) of the time indices at each MCMC iteration.}

\item{time}{Computational time in seconds.}

\item{entropy_MCMC}{A \code{coda::mcmc} object containing MCMC samples of the entropy measure.}

\item{lkl_MCMC}{A \code{coda::mcmc} object containing MCMC samples of the log-likelihood.}

\item{phi_MCMC}{A \code{coda::mcmc} object containing MCMC draws for \eqn{\gamma}.}

\item{sigma_MCMC}{A \code{coda::mcmc} object containing MCMC draws for \eqn{\sigma}.}

\item{delta_MCMC}{A \code{coda::mcmc} object containing MCMC draws for \eqn{\delta}.}

\item{I0_MCMC}{A \code{coda::mcmc} object containing MCMC draws for \eqn{I_0}.}

\item{kernel_ts}{Logical; TRUE if the model for time series data is used.}

\item{kernel_epi}{Logical; TRUE if the epidemic diffusion model is used.}

\item{univariate_ts}{Logical; TRUE if the time series is univariate, FALSE otherwise.}
}
\description{
Constructor for the \code{DetectCpObj} class. This class stores the output
of the Bayesian change–point detection algorithm, including MCMC traces,
allocation orders, and computational information.
}
