% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_cond.R
\name{full_cond}
\alias{full_cond}
\title{Full conditional for lambda}
\usage{
full_cond(kstar, lambda, cluster, al, bl, K, N)
}
\arguments{
\item{kstar}{A scalar with the number maximum of change points in all clusters}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{al}{The hyperparameter value for the shape parameter in the gamma prior for lambda}

\item{bl}{The hyperparameter value for the scale parameter in the gamma prior for lambda}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}

\item{N}{A scalar representing the number of data sequences}
}
\value{
`full_cond` returns a numerical value corresponding to a sample from the full conditional for lambda
}
\description{
Full conditional for lambda
}
\note{
This function is used within the Gibbs sampler, it is not expected to be used alone.
}
\examples{
# Using hypothetical values to exemplification purposes
clusters <- c(1,1,2,1,2)
full_cond(kstar = 2, lambda = 3, cluster = clusters, al = 2, bl = 1000, K = c(2, 2), N = 5)
}
