% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btsr_parent_models.R
\name{BTSR.parent.models}
\alias{BTSR.parent.models}
\alias{BARFIMA.sim}
\alias{BARFIMAV.sim}
\alias{GARFIMA.sim}
\alias{GARFIMAV.sim}
\alias{KARFIMA.sim}
\alias{KARFIMAV.sim}
\alias{MARFIMA.sim}
\alias{ULARFIMA.sim}
\alias{UWARFIMA.sim}
\alias{UWARFIMAV.sim}
\alias{BARFIMA.extract}
\alias{BARFIMAV.extract}
\alias{GARFIMA.extract}
\alias{GARFIMAV.extract}
\alias{KARFIMA.extract}
\alias{KARFIMAV.extract}
\alias{MARFIMA.extract}
\alias{ULARFIMA.extract}
\alias{UWARFIMA.extract}
\alias{UWARFIMAV.extract}
\alias{BARFIMA.fit}
\alias{BARFIMAV.fit}
\alias{GARFIMA.fit}
\alias{GARFIMAV.fit}
\alias{KARFIMA.fit}
\alias{KARFIMAV.fit}
\alias{MARFIMA.fit}
\alias{ULARFIMA.fit}
\alias{UWARFIMA.fit}
\alias{UWARFIMAV.fit}
\title{BTSR models with \eqn{\nu} constant over time}
\usage{
BARFIMA.sim(n = 1, burn = 0, y.start = NULL, xreg = NULL,
  xreg.start = NULL, xregar = TRUE, coefs = NULL, error.scale = 1,
  linkg = "logit", configs.linkg = NULL, inf = 1000, complete = FALSE,
  debug = FALSE)

BARFIMAV.sim(vt.start = NULL, e2.start = NULL, linkg = list(g11 =
  "logit", g2 = "default", g21 = "log"), ...)

GARFIMA.sim(linkg = "log", ...)

GARFIMAV.sim(vt.start = NULL, e2.start = NULL, linkg = list(g11 = "log",
  g2 = "default", g21 = "log"), ...)

KARFIMA.sim(rho = 0.5, y.lower = 0, y.upper = 1, ...)

KARFIMAV.sim(rho = 0.5, y.lower = 0, y.upper = 1, vt.start = NULL,
  e2.start = NULL, linkg = list(g11 = "logit", g2 = "default", g21 =
  "logit"), ...)

MARFIMA.sim(linkg = "cloglog", ...)

ULARFIMA.sim(...)

UWARFIMA.sim(rho = 0.5, ...)

UWARFIMAV.sim(rho = 0.5, vt.start = NULL, e2.start = NULL,
  linkg = list(g11 = "logit", g2 = "default", g21 = "log"), ...)

BARFIMA.extract(yt, xreg = NULL, nnew = 0, xnew = NULL, y.start = NULL,
  xreg.start = NULL, p = NULL, q = NULL, coefs = NULL, lags = NULL,
  fixed.values = NULL, fixed.lags = NULL, xregar = TRUE,
  error.scale = 1, inf = 1000, linkg = "logit", configs.linkg = NULL,
  m = 0, llk = TRUE, sco = FALSE, info = FALSE, extra = FALSE,
  debug = FALSE)

BARFIMAV.extract(vt.start = NULL, e2.start = NULL, linkg = list(g11 =
  "logit", g2 = "default", g21 = "log"), ...)

GARFIMA.extract(linkg = "log", ...)

GARFIMAV.extract(vt.start = NULL, e2.start = NULL, linkg = list(g11 =
  "log", g2 = "default", g21 = "log"), ...)

KARFIMA.extract(rho = 0.5, y.lower = 0, y.upper = 1, ...)

KARFIMAV.extract(rho = 0.5, y.lower = 0, y.upper = 1, vt.start = NULL,
  e2.start = NULL, linkg = list(g11 = "logit", g2 = "default", g21 =
  "logit"), ...)

MARFIMA.extract(linkg = "cloglog", ...)

ULARFIMA.extract(...)

UWARFIMA.extract(rho = 0.5, ...)

UWARFIMAV.extract(rho = 0.5, vt.start = NULL, e2.start = NULL,
  linkg = list(g11 = "logit", g2 = "default", g21 = "log"), ...)

BARFIMA.fit(yt, xreg = NULL, nnew = 0, xnew = NULL, y.start = NULL,
  xreg.start = NULL, p = NULL, d = FALSE, q = NULL, xregar = TRUE,
  inf = 1000, start = NULL, ignore.start = FALSE, lags = NULL,
  fixed.values = NULL, fixed.lags = NULL, lower = NULL, upper = NULL,
  error.scale = 1, linkg = "logit", configs.linkg = NULL, m = 0,
  llk = TRUE, sco = FALSE, info = FALSE, extra = FALSE,
  control = NULL, report = TRUE, debug = FALSE, ...)

BARFIMAV.fit(vt.start = NULL, e2.start = NULL, linkg = list(g11 =
  "logit", g2 = "default", g21 = "log"), ...)

GARFIMA.fit(linkg = "log", ...)

GARFIMAV.fit(vt.start = NULL, e2.start = NULL, linkg = list(g11 = "log",
  g2 = "default", g21 = "log"), ...)

KARFIMA.fit(rho = 0.5, y.lower = 0, y.upper = 1, ...)

KARFIMAV.fit(rho = 0.5, y.lower = 0, y.upper = 1, vt.start = NULL,
  e2.start = NULL, linkg = list(g11 = "logit", g2 = "default", g21 =
  "logit"), ...)

MARFIMA.fit(linkg = "cloglog", ...)

ULARFIMA.fit(...)

UWARFIMA.fit(rho = 0.5, ...)

UWARFIMAV.fit(rho = 0.5, vt.start = NULL, e2.start = NULL,
  linkg = list(g11 = "logit", g2 = "default", g21 = "log"), ...)
}
\arguments{
\item{n}{the sample size of the output time series \code{yt} after burn-in
(simulation only). Default is \code{n = 1}.}

\item{burn}{the length of the \sQuote{burn-in} period (simulation only).
Default is \code{burn = 0}. The first \code{burn} values of the time series are
discarded.}

\item{y.start}{optional; an initial value for \eqn{Y_t} (to initialize
recursions when \eqn{t < 1}). Default is \code{y.start = NULL}, in which case,
the recursion assumes that \eqn{Y_t = g_{12}^{-1}(0)}, for \eqn{t < 1}.
Only relevant if \eqn{p > 0}.}

\item{xreg}{optional; external regressors. Can be specified as a vector, a
matrix or a list. Default is \code{xreg = NULL}. For details, see the Section
\link[=arguments.regressors]{Regressors format}.}

\item{xreg.start}{optional; initial value for the regressors (to initialize
recursion). Can be specified as a vector or a list. Default is
\code{xreg.start = NULL}, in which case, the average of the first \eqn{p}
values (AR order) is used. Only relevant if \code{xreg} is provided, \code{xregar = TRUE} and \eqn{p > 0}. For details, see the Section
\link[=arguments.regressors]{Regressors format}.}

\item{xregar}{a length 1 or 2 logical vector indicating whether \code{xreg} should
be included in the AR recursion for each part of the model. Default is
\code{xregar = TRUE}. Only relevant if \eqn{p > 0}. If a single value is
provided and \eqn{\nu} is time-varying, the same option is assumed for both
parts of the model. See the Section \sQuote{The BTSR structure} in
\link{btsr-package} for details.}

\item{coefs}{a list with the coefficients of the model (simulation and
extraction only). The default is \code{coefs = NULL}. For details on the
expected format and the arguments that can be passed through \code{coefs}, see
the Section \link[=arguments.coefs]{Model coefficients}.}

\item{error.scale}{either 0 or 1; the scale for the error term. Default is
\code{error.scale = 1} (predictive scale).}

\item{linkg}{link functions. Can be specified as a character, two-character
vector or a named list. The corresponding text strings for currently
available links are listed in \link{link.btsr}. Default values depend on the
model. For some models default values override user specifications. See
the Section \link[=arguments.link]{Link defaults} for details.}

\item{configs.linkg}{a list with two elements, \code{ctt} and \code{power}, which
define the constant \eqn{a} and the exponent \eqn{b} in the link function
\eqn{g(x) = a x^b}. Each element can be specified as a numeric value, a
vector of size 2 or a named list. The default is \code{configs.linkg = NULL}.
See the Section \link[=arguments.link]{Link defaults}  for details.}

\item{inf}{a length 1 or 2 integer vector given the truncation point for
infinite sums. Default is \code{inf = 1000}. See the Section \link[=arguments.order]{Model Order} for details.}

\item{complete}{logical; if FALSE returns only \code{yt}, else returns additional
components (simulation only). Default is \code{complete = FALSE}.}

\item{debug}{logical, if \code{TRUE} the output from FORTRAN is return (for
debugging purposes). Default is \code{debug = FALSE}.}

\item{vt.start}{optional; an initial value for  \eqn{\vartheta_t} (to
initialize recursions when \eqn{t < 1}). Default is \code{vt.start = NULL}, in
which case, the recursion assumes that \eqn{\vartheta_t = g_{22}^{-1}(0)},
for \eqn{t < 1}. Only relevant if \eqn{\nu} is time-varying and \eqn{p_2 >
  0}.}

\item{e2.start}{optional; an initial value for  \eqn{g_{23}(e_{1t})} (to
initialize recursions when \eqn{t < 1}). Default is \code{e2.start = NULL}, in
which case, the recursion assumes that \eqn{e_{1t} = g_{23}^{-1}(0)}, for
\eqn{t < 1}. Only relevant if \eqn{\nu} is time-varying and \eqn{q_2 > 0}
or \eqn{d_2 > 0}.}

\item{...}{further arguments passed to the internal functions. See, for
instance, \link{summary.btsr} for details.}

\item{rho}{the quantile being considered in the conditional distribution of
\eqn{Y_t} (only present in Kumaraswamy and Unit-Weibull based models). It
can be any positive number between 0 and 1. Default is \code{rho = 0.5}, which
corresponds to the median.}

\item{y.lower}{the lower limit for the Kumaraswamy density support. Default
is \code{y.lower = 0}.}

\item{y.upper}{the upper limit for the Kumaraswamy density support. Default
is \code{y.upper = 1}.}

\item{yt}{numeric vector with the observed time series (extract and fit
only). Missing values (NA's) are not allowed.}

\item{nnew}{optional; the number of out-of sample predicted values required
(extract and fit only). Default is \code{nnew = 0}.}

\item{xnew}{optional; \code{nnew} new observations of the external regressors
(extract and fit only). Follows the same format is the same as \code{xreg}.
Default is \code{xnew = NULL}.}

\item{p}{optional; a length 1 or 2 integer vector given the order of the AR
polynomial (extract and fit only). Default is \code{p = NULL}. See the Section
\link[=arguments.order]{Model Order} for details.}

\item{q}{optional; a length 1 or 2 integer vector given the order of the MA
polynomial (extract and fit only). Default is \code{q = NULL}. See the Section
\link[=arguments.order]{Model Order} for details.}

\item{lags}{optional; a list with the lags (integer values) that the entries
in \code{coefs} or \code{start} correspond to (extract and fit only). The default is
\code{lags = NULL}, in which the \code{lags} are computed from the \code{fixed.lags}
argument (if provided). When components are missing or empty in both,
\code{lags} and \code{fixed.lags}, the default behavior is to include all lags based
on \code{nreg = ncol(xreg)}, \code{p}, and \code{q}. For details, see the Section \link[=arguments.coefs]{Model coefficients}.}

\item{fixed.values}{optional; a list with the values of the coefficients that
are fixed (extract and fit only). The default is \code{fixed.values = NULL}. See
the Section \link[=arguments.coefs]{Model coefficients}.}

\item{fixed.lags}{optional; a list with the lags (integer values) that the
fixed values in \code{fixed.values} correspond to (extract and fit only). The
default is \code{fixed.lags = NULL}. For missing components, fixed values will
are set based on \code{lags}.}

\item{m}{a non-negative integer indicating the starting time for the sum of
the partial log-likelihood, given by \eqn{\ell = \sum_{t = m+1}^n \ell_t}
(extract and fit only). Default is \code{m = 0}. For details, see the Section
\link[=arguments.loglik]{The log-likelihood}.}

\item{llk}{logical; indicates whether the value of the log-likelihood
function should be returned (extract and fit only). Default is \code{llk =
  TRUE}.}

\item{sco}{logical; indicates whether the score vector should be returned
(extract and fit only). Default is \code{sco = FALSE}.}

\item{info}{logical; indicates whether the information matrix should be
returned (extract and fit only). Default is \code{info = FALSE}. For the fitting
function, \code{info} is automatically set to \code{TRUE} when \code{report = TRUE}.}

\item{extra}{logical, if \code{TRUE} the matrices and vectors used to calculate
the score vector and the information matrix are returned (extract and fit
only). Default is \code{extra = FALSE}. Ignored by BARC models.}

\item{d}{a length 1 or 2 logical vector indicating whether the long memory
parameter \eqn{d} should be included in the model either as a fixed or
non-fixed parameter (fit only). If \code{d = FALSE}, internally the value of the
parameter \code{d} is fixed as 0. In this case, if \code{start} or \code{fixed.values}
include \code{d}, the value provided by the user is ignored.  If \eqn{\nu} is
time-varying and a single value is provided it is assumed that \eqn{d_1 =
  d_2 = d}.}

\item{start}{optional; a list with the starting values for the non-fixed
coefficients of the model (fit only). The default is \code{start = NULL}, in
which case the function \link{coefs.start} is used internally to obtain starting
values for the parameters. For details on the expected format and the
arguments that can be passed through  \code{coefs}, see the Section \link[=arguments.coefs]{Model coefficients}.}

\item{ignore.start}{optional; logical value indicating whether the argument
\code{start} should be ignored (fit only). If starting values are not provided,
the function uses the default values and \code{ignore.start} is ignored. In case
starting values are provided and \code{ignore.start = TRUE}, those starting
values are ignored and recalculated. The default is \code{ignore.start = FALSE}.
Partial starting values are not allowed.}

\item{lower}{optional; list with the lower bounds for the parameters (fit
only). Default is \code{lower = NULL}. The default is to assume that the
parameters have no lower bound except for \code{nu}, for which de default is 0.
Only the bounds for bounded parameters need to be specified. The format of
\code{lower} and the arguments that can be passed through this list are the same
as the ones for \code{start}.}

\item{upper}{optional; list with the upper bounds for the parameters (fit
only). Default is \code{upper = NULL}. The default is to assume that the
parameters have no upper bound. Only the bounds for bounded parameters need
to be specified. The format of \code{lower} and the arguments that can be passed
through this list are the same as the ones for \code{start}.}

\item{control}{a list with configurations to be passed to the optimization
subroutines (fit only). Default is \code{control = NULL}. Missing arguments will
receive default values. For details, see \link{fit.control}.}

\item{report}{logical; indicates whether the summary from the fitted model
should be be printed (fit only). Default is \code{report = TRUE}, in which case
\code{info} is automatically set to \code{TRUE}.}
}
\value{
These functions return the same ouptuts as \link{btsr.sim},
\link{btsr.extract} and \link{btsr.fit}.
}
\description{
Function to simulate, extract components, and fit BTSR parent models
\itemize{
\item \eqn{\nu} constant over time:\cr
BARFIMA, GARFIMA, KARFIMA, MARFIMA, ULARFIMA, and UWARFIMA

\item \eqn{\nu} varying over time: \cr
BARFIMAV, GARFIMAV, KARFIMAV and UWARFIMAV
}
all of which are special cases of the general BTSR structure. See the Section
\sQuote{The BTSR Structure} in \link{btsr-package} for details. These functions
are maintained for backward compatibility.

All models share core arguments with
\itemize{
\item \code{BARFIMA.sim()} for simulation
\item \code{BARFIMA.extract()} for extraction
\item \code{BARFIMA.fit()} for fitting.
}
}
\details{
All functions implemented in the current version of the package are
compatible with the new format for the arguments, introduced in version
1.0.0. and the previous format.
\itemize{
\item The \emph{simulatio functions} (e.g. \code{BARFIMA.sim}) are used to
generate random samples from the corresponding model.

\item The \emph{extraction functions} (e.g. \code{BARFIMA.extract}) allow the
user to extract all conditional time series, the log-likelihood, and the
vectors and matrices used to calculate the score vector and the information
matrix associated to a given set of parameters. This function can be used by
any user to create an objective function that can be passed to optimization
functions not available in BTSR Package. At this point, there is no other
use for which this function was intended.

\item The \emph{fitting functions} (e.g. \code{BARFIMA.fit}) fit the corresponding
model to a given univariate time series. For now, available optimization
algorithms are \code{"L-BFGS-B"} and \code{"Nelder-Mead"}. Both methods accept bounds
for the parameters. For \code{"Nelder-Mead"}, bounds are set via parameter
transformation.
}
}
\examples{
\donttest{
#########################################################################
#
#   Examples of usage of "MODEL.sim" type of functions
#
#########################################################################
#------------------------------------------------------------------------
# iid samples
#------------------------------------------------------------------------
# BARFIMA: yt ~ Beta(a,b), a = mu*nu, b = (1-mu)*nu
# CASE 1: using coefs as in the previous version of the package
set.seed(1234)
yb1 <- BARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5, nu = 20)
)
hist(yb1)

# CASE 2: using the new layout
set.seed(1234)
yb2 <- BARFIMA.sim(
  n = 1000,
  linkg = list(g11 = "linear", g2 = "linear", g21 = "linear"),
  coefs = list(part1 = list(alpha = 0.5), part2 = list(alpha = 20))
)
hist(yb2)

# comparing the results
range(abs(yb2 - yb1))

# samples from other models in the package
yg <- GARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5, nu = 20)
)
yk <- KARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5, nu = 20)
)
ym <- MARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5)
)
yul <- ULARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5)
)
yuw <- UWARFIMA.sim(
  linkg = "linear", n = 1000,
  coefs = list(alpha = 0.5, nu = 20)
)

# comparing the different distributions
par(mfrow = c(2, 3))
hist(yb1, xlim = c(0, 1))
hist(yk, xlim = c(0, 1))
hist(yg, xlim = c(0, 1))
hist(ym, xlim = c(0, 1))
hist(yul, xlim = c(0, 1))
hist(yuw, xlim = c(0, 1))

#------------------------------------------------------------------------
#  BARFIMA(1,d,1) with d = 0.25 and no regressors
#------------------------------------------------------------------------

# CASE 1: using coefs as in the previous version of the package
set.seed(1234)
y1 <- BARFIMA.sim(
  n = 1000,
  linkg = "logit",
  coefs = list(alpha = 0.2, phi = 0.2, theta = 0.4, d = 0.25, nu = 20)
)

# CASE 2: using the new layout
set.seed(1234)
y2 <- BARFIMA.sim(
  n = 1000,
  linkg = list(g11 = "logit", g2 = "linear", g21 = "linear"),
  coefs = list(
    part1 = list(alpha = 0.2, phi = 0.2, theta = 0.4, d = 0.25),
    part2 = list(alpha = 20)
  )
)

# comparing the results
range(abs(y1 - y2))

#########################################################################
#
#   Examples of usage of "MODEL.extract" type of functions
#
#########################################################################

#------------------------------------------------------------------------
#  code to simulate and extract components of a BARMA(1,1) model
#------------------------------------------------------------------------
burn <- 100
n <- 500
N <- n + burn
covar <- cbind(sin(2 * pi * (1:N) / 50), 1:N)

set.seed(1234)
m1 <- BARFIMA.sim(
  linkg = "logit", n = n, burn = burn, xreg = covar,
  coefs = list(
    alpha = 0, phi = -0.65, theta = -0.25,
    beta = c(0.6, -0.002), nu = 20
  ), complete = TRUE
)

# Extracting assuming that all coefficients are non-fixed
e1 <- BARFIMA.extract(
  yt = m1$yt, xreg = covar[(burn + 1):N, ], linkg = "logit",
  coefs = list(
    alpha = 0, phi = -0.65, theta = -0.25,
    beta = c(0.6, -0.002), nu = 20
  ),
  llk = TRUE, sco = TRUE, info = TRUE
)

# Extracting assuming that all coefficients are fixed
e2 <- BARFIMA.extract(
  yt = m1$yt, xreg = covar[(burn + 1):N, ], linkg = "logit",
  fixed.values = list(
    alpha = 0, phi = -0.65, theta = -0.25,
    beta = c(0.6, -0.002), nu = 20
  ),
  llk = TRUE, sco = TRUE, info = TRUE
)

# Extracting using a mix of fixed and non-fixed parameters
e3 <- BARFIMA.extract(
  yt = m1$yt, xreg = covar[(burn + 1):N, ], linkg = "logit",
  coefs = list(
    phi = -0.65, theta = -0.25,
    beta = c(0.6)
  ),
  fixed.values = list(alpha = 0, nu = 20, beta = -0.002),
  fixed.lags = list(beta = 2),
  llk = TRUE, sco = TRUE, info = TRUE
)

# comparing the simulated and the extracted values of mut
cbind(head(m1$mut), head(e1$mut), head(e2$mut), head(e3$mut))

# comparing the log-likelihood values obtained (must be the all equal)
c(e1$sll, e2$sll, e3$sll)

# comparing the score vectors:
# - e1 must have 6 values: dl/dro values and dl/dlambda values
# - e2 must be empty (all parameters are fixed)
# - e3 must have only the values corresponding to the non-fixed coefficients.
round(e1$score, 4)
e2$score
round(e3$score, 4)

# comparing the information matrices.
# - e1 must be a 6x6 matrix
# - e2 must be empty
# - e3 must have only the value corresponding to the non-fixed coefficient
round(e1$info.Matrix, 4)
e2$info.Matrix
round(e3$info.Matrix, 4)

#########################################################################
#
#   Examples of usage of "MODEL.fit" type of functions
#
#########################################################################

#------------------------------------------------------------------------
#  code to simulate and fit a BARMA(1,1) model
#------------------------------------------------------------------------
burn <- 100
n <- 500
N <- n + burn
covar <- cbind(sin(2 * pi * (1:N) / 50), 1:N)

set.seed(1234)
m1 <- BARFIMA.sim(
  linkg = "logit", n = n, burn = burn, xreg = covar,
  coefs = list(
    alpha = 0, phi = -0.65, theta = -0.25,
    beta = c(0.6, -0.002), nu = 20
  ),
  complete = TRUE
)

plot.ts(m1$yt)

# Fit a model assuming that all coefficients are non-fixed
# for a more simplified summary, set full.report = FALSE
f1 <- BARFIMA.fit(
  yt = m1$yt, xreg = covar[(burn + 1):N, ],
  linkg = "logit", p = 1, q = 1, report = TRUE
)

# the fitted coefficients (full model, including d)
coefficients(f1)

# if you try to use `robust` or `outer` without setting `extra = TRUE`, the
# code issues a message and uses the information matrix
summary(f1, robust = TRUE)
summary(f1, outer = TRUE)

# Fit a model assuming alpha and d are fixed
f2 <- BARFIMA.fit(
  yt = m1$yt, xreg = covar[(burn + 1):N, ], linkg = "logit",
  p = 1, q = 1, fixed.values = list(alpha = 0, d = 0)
)
# Alternatively, set `d = FALSE`
f2 <- BARFIMA.fit(
  yt = m1$yt, xreg = covar[(burn + 1):N, ], linkg = "logit",
  p = 1, q = 1, fixed.values = list(alpha = 0), d = FALSE
)

# comparing the results
true <- c(
  alpha = 0, beta = c(0.6, -0.002),
  phi = -0.65, theta = -0.25,
  d = 0, nu = 20
)
cf1 <- coefficients(f1)
cf2 <- c(NA, coefficients(f2)[1:4], NA, coefficients(f2)[5])
round(cbind(true, cf1, cf2), 3)
}
}
\seealso{
\link{BTSR.functions}, \link{BARC.functions}, \link{link.btsr}, \link{get.defaults}
}
