% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Mathpro}
\alias{Mathpro}
\title{Math proficiency and SAT scores by states}
\format{
A data frame/tibble with 51 observations on four variables
\describe{ 
\item{state}{a factor with levels \code{} \code{Conn},
\code{D.C.}, \code{Del}, \code{Ga}, \code{Hawaii}, \code{Ind}, \code{Maine},
\code{Mass}, \code{Md}, \code{N.C.}, \code{N.H.}, \code{N.J.}, \code{N.Y.},
\code{Ore}, \code{Pa}, \code{R.I.}, \code{S.C.}, \code{Va}, and \code{Vt}}
\item{sat_math}{SAT math scores for high school seniors} 
\item{profic}{math proficiency scores for eigth graders} 
\item{group}{a numeric vector} 
}
}
\source{
National Assessment of Educational Progress and The College Board.
}
\usage{
Mathpro
}
\description{
Data for Exercise 9.24, Example 9.1, and Example 9.6
}
\examples{

model <- lm(sat_math ~ profic, data = Mathpro)
plot(sat_math ~ profic, data = Mathpro, ylab = "SAT", xlab = "proficiency")
abline(model, col = "red")
summary(model)
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
