% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\docType{data}
\name{sample_data}
\alias{sample_data}
\title{Micronutrient biomarker dataset}
\format{
An object of class \code{"data.frame"}
\describe{
 \item{id}{Unique identification numbers}
 \item{sf}{Serum ferritin, µg/l}
 \item{stfr}{Soluble transferrin receptor, mg/L}
 \item{rbp}{Retinol binding protein, µmol/L}
 \item{sr}{Serum retinol, µmol/L}
 \item{zinc}{Zinc, µg/L}
 \item{crp}{C-reactive Protein, mg/L}
 \item{agp}{Alpha1-acid glycoprotein, g/L}
}
}
\usage{
data(sample_data)
}
\description{
A biomarker data set that was subset from a cross-sectional survey in
Malawi. It provides de-identified information for serum ferritin, soluble
transferrin receptor, retinol binding protein, retinol, zinc, C-reactive
protein (CRP), Alpha1-acid glycoprotein (AGP) to illustrate the use of the
package.
}
\references{
National Statistical Office (NSO), Community Health Sciences Unit
 (CHSU) [Malawi], Centers for Disease Control and Prevention (CDC), and Emory
 University. 2017. Malawi Micronutrient Survey 2015-16. Atlanta, GA, USA:
 NSO, CHSU, CDC, and Emory University
}
\keyword{datasets}
