% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_MADCs.R
\name{merge_MADCs}
\alias{merge_MADCs}
\title{Merge MADC files}
\usage{
merge_MADCs(..., madc_list = NULL, out_madc = NULL, run_ids = NULL)
}
\arguments{
\item{...}{one or more MADC files path}

\item{madc_list}{list containing path to MADC files to be merged}

\item{out_madc}{output merged MADC file path}

\item{run_ids}{vector of character defining the run ID for each file.
This ID will be added as a suffix in repeated sample ID in case they
exist in different files.}
}
\value{
A data frame containing the merged MADC data. The merged file is also written to the specified \code{out_madc} path in CSV format. Numeric columns are filled with zeros where data is missing.
}
\description{
If duplicated samples exist in different files, a suffix will
be added at the end of the sample name. If run_ids is defined,
they are used as suffix, if not, files will be identified from
1 to number of files, considering the order that was defined
in the function.
}
\examples{
# First generating example MADC files
temp_dir <- tempdir()
file1_path <- file.path(temp_dir, "madc1.csv")
file2_path <- file.path(temp_dir, "madc2.csv")
out_path <- file.path(temp_dir, "merged_madc.csv")

# Data for file 1: Has SampleA and SampleB
df1 <- data.frame(
  AlleleID = c("chr1.1_0001|Alt_0002", "chr1.1_0001|Ref_0001", "chr1.1_0001|AltMatch_0001"),
  CloneID = c("chr1.1_0001", "chr1.1_0001", "chr1.1_0001"),
  AlleleSequence = c("GGG", "AAA", "TTT"),
  SampleA = c(10, 8, 0),
  SampleB = c(5, 4, 9),
  stringsAsFactors = FALSE,
  check.names = FALSE
)
write.csv(df1, file1_path, row.names = FALSE, quote = FALSE)

# Data for file 2: Has SampleA (duplicate name) and SampleC, different rows
df2 <- data.frame(
  AlleleID = c("chr1.1_0001|Alt_0002", "chr1.1_0001|Ref_0001", "chr1.1_0001|AltMatch_0001"),
  CloneID = c("chr1.1_0001", "chr1.1_0001", "chr1.1_0001"),
  AlleleSequence = c("GGG", "AAA", "TTT"),
  SampleA = c(11, 7, 20),
  SampleC = c(1, 2, 6),
  stringsAsFactors = FALSE,
  check.names = FALSE
)
write.csv(df2, file2_path, row.names = FALSE, quote = FALSE)

# 2. Run the merge function
# Use default suffixes (.x, .y) for the duplicated "SampleA"
merge_MADCs(madc_list = list(file1_path, file2_path),
            out_madc = out_path)


}
